/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import java.util.HashMap;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.jberet.job.model.Properties;
import org.jberet.job.model.Script;
import org.jberet.runtime.context.StepContextImpl;

abstract class ScriptArtifactBase {
    final Script script;
    final Properties artifactProperties;
    final StepContextImpl stepContext;
    final ScriptEngine engine;
    CompiledScript compiledScript;
    final String scriptContent;
    Map<String, String> methodMapping;

    public ScriptArtifactBase(Script script, Properties artifactProperties, StepContextImpl stepContext) throws ScriptException {
        String methodMappingVal;
        this.script = script;
        this.artifactProperties = artifactProperties;
        this.stepContext = stepContext;
        ClassLoader classLoader = stepContext.getClassLoader();
        this.scriptContent = script.getContent(classLoader);
        this.engine = script.getEngine(classLoader);
        this.setEngineScopeAttributes();
        if (this.engine instanceof Compilable) {
            this.compiledScript = ((Compilable)((Object)this.engine)).compile(this.scriptContent);
        }
        if (artifactProperties != null && (methodMappingVal = artifactProperties.get("methodMapping")) != null) {
            String[] pairs;
            this.methodMapping = new HashMap<String, String>();
            for (String pair : pairs = methodMappingVal.split(",")) {
                String[] keyValue = pair.split("=");
                this.methodMapping.put(keyValue[0].trim(), keyValue[1].trim());
            }
        }
    }

    void setEngineScopeAttributes() {
        ScriptContext scriptContext = this.engine.getContext();
        scriptContext.setAttribute("jobContext", this.stepContext.getJobContext(), 100);
        scriptContext.setAttribute("stepContext", this.stepContext, 100);
        scriptContext.setAttribute("batchProperties", Properties.toJavaUtilProperties(this.artifactProperties), 100);
    }

    String getFunctionName(String batchApiMethodName) {
        if (this.methodMapping == null) {
            return batchApiMethodName;
        }
        String functionName = this.methodMapping.get(batchApiMethodName);
        return functionName == null ? batchApiMethodName : functionName;
    }
}

