/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.server.Services;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.JBossThreadFactory;
import org.jboss.weld.executor.AbstractExecutorServices;
import org.jboss.weld.manager.api.ExecutorServices;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldExecutorServices
extends AbstractExecutorServices
implements Service<ExecutorServices> {
    public static final ServiceName SERVICE_NAME = Services.JBOSS_AS.append(new String[]{"weld", "executor"});
    private static final String THREAD_NAME_PATTERN = "Weld Thread Pool -- %t";
    private final int bound = Runtime.getRuntime().availableProcessors() + 1;
    private ExecutorService executor;

    public void start(StartContext context) throws StartException {
        ThreadGroup threadGroup = new ThreadGroup("Weld ThreadGroup");
        JBossThreadFactory factory = new JBossThreadFactory(threadGroup, Boolean.FALSE, null, THREAD_NAME_PATTERN, null, null);
        this.executor = Executors.newFixedThreadPool(this.bound, arg_0 -> this.lambda$start$0((ThreadFactory)factory, arg_0));
    }

    public void stop(StopContext context) {
        if (this.executor != null) {
            context.asynchronous();
            new Thread(() -> {
                super.cleanup();
                this.executor = null;
                context.complete();
            }).start();
        }
    }

    protected synchronized int getThreadPoolSize() {
        return this.bound;
    }

    public synchronized ExecutorServices getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public synchronized ExecutorService getTaskExecutor() {
        return this.executor;
    }

    public void cleanup() {
    }

    private /* synthetic */ Thread lambda$start$0(ThreadFactory threadFactory, Runnable runnable) {
        final Thread thread = threadFactory.newThread(runnable);
        if (WildFlySecurityManager.isChecking()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    thread.setContextClassLoader(null);
                    return null;
                }
            });
        } else {
            thread.setContextClassLoader(null);
        }
        return thread;
    }
}

