/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Set;
import org.jboss.as.clustering.controller.ReloadRequiredAddStepHandler;
import org.jboss.as.clustering.controller.transform.SimpleAttributeConverter;
import org.jboss.as.clustering.controller.transform.SimpleRejectAttributeChecker;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class TransportResourceDefinition
extends SimpleResourceDefinition {
    static final PathElement PATH = PathElement.pathElement((String)"transport", (String)"TRANSPORT");
    static final SimpleAttributeDefinition CHANNEL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("channel", ModelType.STRING, true).setXmlName(Attribute.CHANNEL.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    static final SimpleAttributeDefinition EXECUTOR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("executor", ModelType.STRING, true).setXmlName(Attribute.EXECUTOR.getLocalName())).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDeprecated(InfinispanModel.VERSION_3_0_0.getVersion())).build();
    static final SimpleAttributeDefinition LOCK_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("lock-timeout", ModelType.LONG, true).setXmlName(Attribute.LOCK_TIMEOUT.getLocalName())).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode().set(240000L))).build();
    @Deprecated
    static final SimpleAttributeDefinition STACK = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("stack", ModelType.STRING, true).setXmlName(Attribute.STACK.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDeprecated(InfinispanModel.VERSION_3_0_0.getVersion())).build();
    @Deprecated
    static final SimpleAttributeDefinition CLUSTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cluster", ModelType.STRING, true).setXmlName(Attribute.CLUSTER.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDeprecated(InfinispanModel.VERSION_3_0_0.getVersion())).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CHANNEL, STACK, EXECUTOR, LOCK_TIMEOUT};

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(PATH);
        if (InfinispanModel.VERSION_3_0_0.requiresTransformation(version)) {
            SimpleRejectAttributeChecker.Rejecter stackRejecter = new SimpleRejectAttributeChecker.Rejecter(){

                public boolean reject(PathAddress address, String name, ModelNode value, ModelNode model, TransformationContext context) {
                    ModelNode defaultChannel;
                    if (value.isDefined()) {
                        return false;
                    }
                    PathAddress rootAddress = address.subAddress(0, address.size() - 3);
                    PathAddress subsystemAddress = rootAddress.append(new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
                    ModelNode subsystemModel = context.readResourceFromRoot(subsystemAddress).getModel();
                    String channelName = null;
                    if (model.hasDefined(CHANNEL.getName())) {
                        ModelNode channel = model.get(CHANNEL.getName());
                        if (channel.getType() == ModelType.STRING) {
                            channelName = channel.asString();
                        }
                    } else if (subsystemModel.hasDefined(JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL.getName()) && (defaultChannel = subsystemModel.get(JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL.getName())).getType() == ModelType.STRING) {
                        channelName = defaultChannel.asString();
                    }
                    if (channelName == null) {
                        return true;
                    }
                    String stackName = null;
                    PathAddress channelAddress = subsystemAddress.append(new PathElement[]{ChannelResourceDefinition.pathElement((String)channelName)});
                    try {
                        ModelNode defaultStack;
                        ModelNode channel = context.readResourceFromRoot(channelAddress).getModel();
                        if (channel.hasDefined(ChannelResourceDefinition.STACK.getName())) {
                            ModelNode stack = channel.get(ChannelResourceDefinition.STACK.getName());
                            if (stack.getType() == ModelType.STRING) {
                                stackName = stack.asString();
                            }
                        } else if (subsystemModel.hasDefined(JGroupsSubsystemResourceDefinition.DEFAULT_STACK.getName()) && (defaultStack = subsystemModel.get(JGroupsSubsystemResourceDefinition.DEFAULT_STACK.getName())).getType() == ModelType.STRING) {
                            stackName = defaultStack.asString();
                        }
                    }
                    catch (Resource.NoSuchResourceException e) {
                        // empty catch block
                    }
                    return stackName == null;
                }

                public String getRejectedMessage(Set<String> attributes) {
                    return InfinispanLogger.ROOT_LOGGER.indeterminiteStack();
                }
            };
            SimpleAttributeConverter.Converter stackConverter = new SimpleAttributeConverter.Converter(){

                public void convert(PathAddress address, String name, ModelNode value, ModelNode model, TransformationContext context) {
                    if (!value.isDefined()) {
                        ModelNode defaultChannel;
                        PathAddress rootAddress = address.subAddress(0, address.size() - 3);
                        PathAddress subsystemAddress = rootAddress.append(new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
                        ModelNode subsystemModel = context.readResourceFromRoot(subsystemAddress).getModel();
                        String channelName = null;
                        if (model.hasDefined(CHANNEL.getName())) {
                            ModelNode channel = model.get(CHANNEL.getName());
                            if (channel.getType() == ModelType.STRING) {
                                channelName = channel.asString();
                            }
                        } else if (subsystemModel.hasDefined(JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL.getName()) && (defaultChannel = subsystemModel.get(JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL.getName())).getType() == ModelType.STRING) {
                            channelName = defaultChannel.asString();
                        }
                        if (channelName != null) {
                            PathAddress channelAddress = subsystemAddress.append(new PathElement[]{ChannelResourceDefinition.pathElement((String)channelName)});
                            try {
                                ModelNode defaultStack;
                                ModelNode channel = context.readResourceFromRoot(channelAddress).getModel();
                                if (channel.hasDefined(ChannelResourceDefinition.STACK.getName())) {
                                    ModelNode stack = channel.get(ChannelResourceDefinition.STACK.getName());
                                    if (stack.getType() == ModelType.STRING) {
                                        value.set(stack.asString());
                                    }
                                } else if (subsystemModel.hasDefined(JGroupsSubsystemResourceDefinition.DEFAULT_STACK.getName()) && (defaultStack = subsystemModel.get(JGroupsSubsystemResourceDefinition.DEFAULT_STACK.getName())).getType() == ModelType.STRING) {
                                    value.set(defaultStack.asString());
                                }
                            }
                            catch (Resource.NoSuchResourceException e) {
                                // empty catch block
                            }
                        }
                    }
                }
            };
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new SimpleRejectAttributeChecker(stackRejecter), new AttributeDefinition[]{STACK})).setValueConverter((AttributeConverter)new SimpleAttributeConverter(stackConverter), new AttributeDefinition[]{STACK})).addRename((AttributeDefinition)CHANNEL, CLUSTER.getName())).end();
        }
    }

    TransportResourceDefinition() {
        super(PATH, (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("transport"), (OperationStepHandler)new ReloadRequiredAddStepHandler(ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
    }
}

