/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.util.Collection;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.interceptors.NegotiationUtils;
import org.apache.cxf.ws.security.policy.interceptors.SpnegoTokenInterceptorProvider;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.ws.security.trust.STSUtils;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.spnego.SpnegoClientAction;
import org.apache.wss4j.common.spnego.SpnegoTokenContext;
import org.apache.wss4j.policy.model.Trust10;
import org.apache.wss4j.policy.model.Trust13;
import org.apache.xml.security.utils.Base64;

class SpnegoContextTokenOutInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    public SpnegoContextTokenOutInterceptor() {
        super("prepare-send");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (aim != null) {
            Collection<AssertionInfo> ais = NegotiationUtils.getAllAssertionsByLocalname(aim, "SpnegoContextToken");
            if (ais.isEmpty()) {
                return;
            }
            if (this.isRequestor((Message)message)) {
                String tokId = (String)message.getContextualProperty("ws-security.token.id");
                SecurityToken tok = null;
                if (tokId != null && (tok = NegotiationUtils.getTokenStore((Message)message).getToken(tokId)) != null && tok.isExpired()) {
                    ((Endpoint)message.getExchange().get(Endpoint.class)).remove((Object)"ws-security.token.id");
                    message.getExchange().remove((Object)"ws-security.token.id");
                    NegotiationUtils.getTokenStore((Message)message).remove(tokId);
                    tok = null;
                }
                if (tok == null) {
                    tok = this.issueToken(message, aim);
                }
                if (tok != null) {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                    ((Endpoint)message.getExchange().get(Endpoint.class)).put((Object)"ws-security.token.id", (Object)tok.getId());
                    message.getExchange().put((Object)"ws-security.token.id", (Object)tok.getId());
                    NegotiationUtils.getTokenStore((Message)message).add(tok);
                }
            } else {
                for (AssertionInfo ai : ais) {
                    ai.setAsserted(true);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SecurityToken issueToken(SoapMessage message, AssertionInfoMap aim) {
        String jaasContext = (String)message.getContextualProperty("ws-security.kerberos.jaas.context");
        String kerberosSpn = (String)message.getContextualProperty("ws-security.kerberos.spn");
        CallbackHandler callbackHandler = NegotiationUtils.getCallbackHandler(message.getContextualProperty("ws-security.callback-handler"), ((Object)((Object)this)).getClass());
        SpnegoTokenContext spnegoToken = new SpnegoTokenContext();
        Object spnegoClientAction = message.getContextualProperty("ws-security.spnego.client.action");
        if (spnegoClientAction instanceof SpnegoClientAction) {
            spnegoToken.setSpnegoClientAction((SpnegoClientAction)spnegoClientAction);
        }
        try {
            spnegoToken.retrieveServiceTicket(jaasContext, callbackHandler, kerberosSpn);
        }
        catch (WSSecurityException e) {
            throw new Fault((Throwable)e);
        }
        STSClient client = STSUtils.getClient((Message)message, "spnego");
        AddressingProperties maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context.outbound");
        if (maps == null) {
            maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context");
        }
        STSClient sTSClient = client;
        synchronized (sTSClient) {
            try {
                String s = SpnegoTokenInterceptorProvider.setupClient(client, message, aim);
                if (maps != null) {
                    client.setAddressingNamespace(maps.getNamespaceURI());
                }
                SecurityToken tok = client.requestSecurityToken(s, Base64.encode((byte[])spnegoToken.getToken()));
                byte[] wrappedTok = spnegoToken.unwrapKey(tok.getSecret());
                tok.setSecret(wrappedTok);
                spnegoToken.clear();
                SecurityToken securityToken = tok;
                return securityToken;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
            finally {
                client.setTrust(null);
                client.setTrust((Trust10)((Trust13)null));
                client.setTemplate(null);
                client.setLocation(null);
                client.setAddressingNamespace(null);
            }
        }
    }
}

