/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.management.impl;

import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.Parameter;
import org.apache.activemq.artemis.api.jms.management.ConnectionFactoryControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.server.JMSServerManager;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;

public class JMSConnectionFactoryControlImpl
extends StandardMBean
implements ConnectionFactoryControl {
    private final ConnectionFactoryConfiguration cfConfig;
    private ActiveMQConnectionFactory cf;
    private final String name;
    private final JMSServerManager jmsManager;

    public JMSConnectionFactoryControlImpl(ConnectionFactoryConfiguration cfConfig, ActiveMQConnectionFactory cf, JMSServerManager jmsManager, String name) throws NotCompliantMBeanException {
        super(ConnectionFactoryControl.class);
        this.cfConfig = cfConfig;
        this.cf = cf;
        this.name = name;
        this.jmsManager = jmsManager;
    }

    public String[] getRegistryBindings() {
        return this.jmsManager.getBindingsOnConnectionFactory(this.name);
    }

    public boolean isCompressLargeMessages() {
        return this.cf.isCompressLargeMessage();
    }

    public void setCompressLargeMessages(boolean compress) {
        this.cfConfig.setCompressLargeMessages(compress);
        this.recreateCF();
    }

    public boolean isHA() {
        return this.cfConfig.isHA();
    }

    public int getFactoryType() {
        return this.cfConfig.getFactoryType().intValue();
    }

    public String getClientID() {
        return this.cfConfig.getClientID();
    }

    public long getClientFailureCheckPeriod() {
        return this.cfConfig.getClientFailureCheckPeriod();
    }

    public void setClientID(String clientID) {
        this.cfConfig.setClientID(clientID);
        this.recreateCF();
    }

    public void setDupsOKBatchSize(int dupsOKBatchSize) {
        this.cfConfig.setDupsOKBatchSize(dupsOKBatchSize);
        this.recreateCF();
    }

    public void setTransactionBatchSize(int transactionBatchSize) {
        this.cfConfig.setTransactionBatchSize(transactionBatchSize);
        this.recreateCF();
    }

    public void setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.cfConfig.setClientFailureCheckPeriod(clientFailureCheckPeriod);
        this.recreateCF();
    }

    public void setConnectionTTL(long connectionTTL) {
        this.cfConfig.setConnectionTTL(connectionTTL);
        this.recreateCF();
    }

    public void setCallTimeout(long callTimeout) {
        this.cfConfig.setCallTimeout(callTimeout);
        this.recreateCF();
    }

    public void setCallFailoverTimeout(long callTimeout) {
        this.cfConfig.setCallFailoverTimeout(callTimeout);
        this.recreateCF();
    }

    public void setConsumerWindowSize(int consumerWindowSize) {
        this.cfConfig.setConsumerWindowSize(consumerWindowSize);
        this.recreateCF();
    }

    public void setConsumerMaxRate(int consumerMaxRate) {
        this.cfConfig.setConsumerMaxRate(consumerMaxRate);
        this.recreateCF();
    }

    public void setConfirmationWindowSize(int confirmationWindowSize) {
        this.cfConfig.setConfirmationWindowSize(confirmationWindowSize);
        this.recreateCF();
    }

    public void setProducerMaxRate(int producerMaxRate) {
        this.cfConfig.setProducerMaxRate(producerMaxRate);
        this.recreateCF();
    }

    public int getProducerWindowSize() {
        return this.cfConfig.getProducerWindowSize();
    }

    public void setProducerWindowSize(int producerWindowSize) {
        this.cfConfig.setProducerWindowSize(producerWindowSize);
        this.recreateCF();
    }

    public void setCacheLargeMessagesClient(boolean cacheLargeMessagesClient) {
        this.cfConfig.setCacheLargeMessagesClient(cacheLargeMessagesClient);
        this.recreateCF();
    }

    public boolean isCacheLargeMessagesClient() {
        return this.cfConfig.isCacheLargeMessagesClient();
    }

    public void setMinLargeMessageSize(int minLargeMessageSize) {
        this.cfConfig.setMinLargeMessageSize(minLargeMessageSize);
        this.recreateCF();
    }

    public void setBlockOnNonDurableSend(boolean blockOnNonDurableSend) {
        this.cfConfig.setBlockOnNonDurableSend(blockOnNonDurableSend);
        this.recreateCF();
    }

    public void setBlockOnAcknowledge(boolean blockOnAcknowledge) {
        this.cfConfig.setBlockOnAcknowledge(blockOnAcknowledge);
        this.recreateCF();
    }

    public void setBlockOnDurableSend(boolean blockOnDurableSend) {
        this.cfConfig.setBlockOnDurableSend(blockOnDurableSend);
        this.recreateCF();
    }

    public void setAutoGroup(boolean autoGroup) {
        this.cfConfig.setAutoGroup(autoGroup);
        this.recreateCF();
    }

    public void setPreAcknowledge(boolean preAcknowledge) {
        this.cfConfig.setPreAcknowledge(preAcknowledge);
        this.recreateCF();
    }

    public void setMaxRetryInterval(long retryInterval) {
        this.cfConfig.setMaxRetryInterval(retryInterval);
        this.recreateCF();
    }

    public void setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.cfConfig.setRetryIntervalMultiplier(retryIntervalMultiplier);
        this.recreateCF();
    }

    public void setReconnectAttempts(int reconnectAttempts) {
        this.cfConfig.setReconnectAttempts(reconnectAttempts);
        this.recreateCF();
    }

    public void setFailoverOnInitialConnection(boolean failover) {
        this.cfConfig.setFailoverOnInitialConnection(failover);
        this.recreateCF();
    }

    public boolean isUseGlobalPools() {
        return this.cfConfig.isUseGlobalPools();
    }

    public void setScheduledThreadPoolMaxSize(int scheduledThreadPoolMaxSize) {
        this.cfConfig.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
        this.recreateCF();
    }

    public int getThreadPoolMaxSize() {
        return this.cfConfig.getThreadPoolMaxSize();
    }

    public void setThreadPoolMaxSize(int threadPoolMaxSize) {
        this.cfConfig.setThreadPoolMaxSize(threadPoolMaxSize);
        this.recreateCF();
    }

    public int getInitialMessagePacketSize() {
        return this.cf.getInitialMessagePacketSize();
    }

    public void setGroupID(String groupID) {
        this.cfConfig.setGroupID(groupID);
        this.recreateCF();
    }

    public String getGroupID() {
        return this.cfConfig.getGroupID();
    }

    public void setUseGlobalPools(boolean useGlobalPools) {
        this.cfConfig.setUseGlobalPools(useGlobalPools);
        this.recreateCF();
    }

    public int getScheduledThreadPoolMaxSize() {
        return this.cfConfig.getScheduledThreadPoolMaxSize();
    }

    public void setRetryInterval(long retryInterval) {
        this.cfConfig.setRetryInterval(retryInterval);
        this.recreateCF();
    }

    public long getMaxRetryInterval() {
        return this.cfConfig.getMaxRetryInterval();
    }

    public String getConnectionLoadBalancingPolicyClassName() {
        return this.cfConfig.getLoadBalancingPolicyClassName();
    }

    public void setConnectionLoadBalancingPolicyClassName(String name) {
        this.cfConfig.setLoadBalancingPolicyClassName(name);
        this.recreateCF();
    }

    public TransportConfiguration[] getStaticConnectors() {
        return this.cf.getStaticConnectors();
    }

    public DiscoveryGroupConfiguration getDiscoveryGroupConfiguration() {
        return this.cf.getDiscoveryGroupConfiguration();
    }

    public void addBinding(@Parameter(name="binding", desc="the name of the binding for the Registry") String binding) throws Exception {
        this.jmsManager.addConnectionFactoryToBindingRegistry(this.name, binding);
    }

    public void removeBinding(@Parameter(name="binding", desc="the name of the binding for the Registry") String binding) throws Exception {
        this.jmsManager.removeConnectionFactoryFromBindingRegistry(this.name, binding);
    }

    public long getCallTimeout() {
        return this.cfConfig.getCallTimeout();
    }

    public long getCallFailoverTimeout() {
        return this.cfConfig.getCallFailoverTimeout();
    }

    public int getConsumerMaxRate() {
        return this.cfConfig.getConsumerMaxRate();
    }

    public int getConsumerWindowSize() {
        return this.cfConfig.getConsumerWindowSize();
    }

    public int getProducerMaxRate() {
        return this.cfConfig.getProducerMaxRate();
    }

    public int getConfirmationWindowSize() {
        return this.cfConfig.getConfirmationWindowSize();
    }

    public int getDupsOKBatchSize() {
        return this.cfConfig.getDupsOKBatchSize();
    }

    public boolean isBlockOnAcknowledge() {
        return this.cfConfig.isBlockOnAcknowledge();
    }

    public boolean isBlockOnNonDurableSend() {
        return this.cfConfig.isBlockOnNonDurableSend();
    }

    public boolean isBlockOnDurableSend() {
        return this.cfConfig.isBlockOnDurableSend();
    }

    public boolean isPreAcknowledge() {
        return this.cfConfig.isPreAcknowledge();
    }

    public String getName() {
        return this.name;
    }

    public long getConnectionTTL() {
        return this.cfConfig.getConnectionTTL();
    }

    public int getReconnectAttempts() {
        return this.cfConfig.getReconnectAttempts();
    }

    public boolean isFailoverOnInitialConnection() {
        return this.cfConfig.isFailoverOnInitialConnection();
    }

    public int getMinLargeMessageSize() {
        return this.cfConfig.getMinLargeMessageSize();
    }

    public long getRetryInterval() {
        return this.cfConfig.getRetryInterval();
    }

    public double getRetryIntervalMultiplier() {
        return this.cfConfig.getRetryIntervalMultiplier();
    }

    public int getTransactionBatchSize() {
        return this.cfConfig.getTransactionBatchSize();
    }

    public boolean isAutoGroup() {
        return this.cfConfig.isAutoGroup();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = super.getMBeanInfo();
        return new MBeanInfo(info.getClassName(), info.getDescription(), info.getAttributes(), info.getConstructors(), MBeanInfoHelper.getMBeanOperationsInfo(ConnectionFactoryControl.class), info.getNotifications());
    }

    private void recreateCF() {
        try {
            this.cf = this.jmsManager.recreateCF(this.name, this.cfConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

