/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.ManagedBindingRegistry;
import org.jboss.as.network.NetworkUtils;

public class ManagedMulticastSocketBinding
extends MulticastSocket
implements ManagedBinding {
    private final String name;
    private final ManagedBindingRegistry socketBindings;

    static ManagedMulticastSocketBinding create(String name, ManagedBindingRegistry socketBindings, SocketAddress address) throws IOException {
        if (NetworkUtils.isBindingToMulticastDressSupported()) {
            return new ManagedMulticastSocketBinding(name, socketBindings, address);
        }
        if (address instanceof InetSocketAddress) {
            return new ManagedMulticastSocketBinding(name, socketBindings, ((InetSocketAddress)address).getPort());
        }
        return new ManagedMulticastSocketBinding(name, socketBindings, address);
    }

    private ManagedMulticastSocketBinding(String name, ManagedBindingRegistry socketBindings, SocketAddress address) throws IOException {
        super(address);
        this.name = name;
        this.socketBindings = socketBindings;
    }

    private ManagedMulticastSocketBinding(String name, ManagedBindingRegistry socketBindings, int port) throws IOException {
        super(port);
        this.name = name;
        this.socketBindings = socketBindings;
    }

    @Override
    public String getSocketBindingName() {
        return this.name;
    }

    @Override
    public InetSocketAddress getBindAddress() {
        return (InetSocketAddress)this.getLocalSocketAddress();
    }

    @Override
    public synchronized void bind(SocketAddress addr) throws SocketException {
        super.bind(addr);
        this.socketBindings.registerBinding(this);
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.socketBindings.unregisterBinding(this);
        }
    }
}

