/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service.management;

import java.beans.ConstructorProperties;
import java.io.Serializable;

public class ServiceStatus
implements Serializable {
    private static final long serialVersionUID = 6538576441150451665L;
    private final String serviceName;
    private final String[] aliases;
    private final String serviceClassName;
    private final String modeName;
    private final String stateName;
    private final String substateName;
    private final String[] dependencies;
    private final boolean dependencyFailed;
    private final boolean dependencyUnavailable;
    private final String parentName;
    private final String exception;

    @ConstructorProperties(value={"parentName", "serviceName", "serviceClassName", "modeName", "stateName", "substateName", "dependencies", "dependencyFailed", "exception", "dependencyUnavailable"})
    public ServiceStatus(String parentName, String serviceName, String[] aliases, String serviceClassName, String modeName, String stateName, String substateName, String[] dependencies, boolean dependencyFailed, String exception, boolean dependencyUnavailable) {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName is null");
        }
        if (aliases == null) {
            throw new IllegalArgumentException("aliases is null");
        }
        if (serviceClassName == null) {
            throw new IllegalArgumentException("serviceClassName is null");
        }
        if (modeName == null) {
            throw new IllegalArgumentException("modeName is null");
        }
        if (stateName == null) {
            throw new IllegalArgumentException("stateName is null");
        }
        if (substateName == null) {
            throw new IllegalArgumentException("substateName is null");
        }
        if (dependencies == null) {
            throw new IllegalArgumentException("dependencies is null");
        }
        this.serviceName = serviceName;
        this.aliases = aliases;
        this.serviceClassName = serviceClassName;
        this.modeName = modeName;
        this.stateName = stateName;
        this.substateName = substateName;
        this.dependencies = dependencies;
        this.dependencyFailed = dependencyFailed;
        this.dependencyUnavailable = dependencyUnavailable;
        this.parentName = parentName;
        this.exception = exception;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getServiceClassName() {
        return this.serviceClassName;
    }

    public String getModeName() {
        return this.modeName;
    }

    public String getStateName() {
        return this.stateName;
    }

    public String getSubstateName() {
        return this.substateName;
    }

    public String[] getDependencies() {
        return this.dependencies;
    }

    public boolean isDependencyFailed() {
        return this.dependencyFailed;
    }

    public boolean isDependencyUnavailable() {
        return this.dependencyUnavailable;
    }

    public String getException() {
        return this.exception;
    }

    public String toString() {
        String exception;
        String[] dependencies;
        int dependenciesLength;
        String parentName;
        StringBuilder builder = new StringBuilder();
        builder.append("Service \"").append(this.serviceName).append("\" ");
        String[] aliases = this.aliases;
        if (aliases.length > 0) {
            builder.append("(aliases: ");
            for (int i = 0; i < aliases.length; ++i) {
                builder.append(aliases[i]);
                if (i >= aliases.length - 1) continue;
                builder.append(", ");
            }
            builder.append(") ");
        }
        builder.append("(class ").append(this.serviceClassName).append(')');
        builder.append(" mode ").append(this.modeName);
        builder.append(" state ").append(this.stateName);
        if (!this.stateName.equals(this.substateName)) {
            builder.append(" (").append(this.substateName).append(')');
        }
        if ((parentName = this.parentName) != null) {
            builder.append(" (parent: ").append(parentName).append(')');
        }
        if ((dependenciesLength = (dependencies = this.dependencies).length) > 0) {
            builder.append(" (dependencies: ");
            for (int i = 0; i < dependenciesLength; ++i) {
                builder.append(dependencies[i]);
                if (i >= dependenciesLength - 1) continue;
                builder.append(", ");
            }
            builder.append(")");
        }
        if ((exception = this.exception) != null && !exception.isEmpty()) {
            builder.append(" (failure cause: ").append(exception).append(')');
        }
        if (this.dependencyFailed) {
            builder.append(" (has failed dependency)");
        }
        if (this.dependencyUnavailable) {
            builder.append(" (has unavailable dependency)");
        }
        return builder.toString();
    }

    public String getParentName() {
        return this.parentName;
    }
}

