/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.producer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.picketlink.PartitionManagerCreateEvent;
import org.picketlink.annotations.PicketLink;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.PermissionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.internal.DefaultPartitionManager;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.basic.Realm;
import org.picketlink.idm.permission.acl.spi.PermissionHandler;
import org.picketlink.internal.CDIEventBridge;
import org.picketlink.internal.SecuredIdentityManager;
import org.picketlink.log.BaseLog;
import org.picketlink.producer.IdentityManagementConfiguration;

@ApplicationScoped
public class IdentityManagementProducer {
    @Inject
    @PicketLink
    private Instance<Partition> defaultPartition;
    @Inject
    private IdentityManagementConfiguration identityManagementConfiguration;
    @Inject
    @PicketLink
    private Instance<PartitionManager> partitionManagerInstance;
    @Inject
    private Instance<PermissionHandler> permissionHandlerInstance;
    @Inject
    private CDIEventBridge eventBridge;
    private PartitionManager partitionManager;

    @Inject
    public void init() {
        if (this.partitionManager != null) {
            throw new RuntimeException("Identity Management Subsystem already initialized.");
        }
        if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
            BaseLog.ROOT_LOGGER.debugf("Initializing Identity Management Subsystem.", new Object[0]);
        }
        if (!this.partitionManagerInstance.isUnsatisfied()) {
            this.partitionManager = (PartitionManager)this.partitionManagerInstance.get();
            if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                BaseLog.ROOT_LOGGER.debugf("PartitionManager provided by the application.", new Object[0]);
            }
        } else {
            this.partitionManager = this.createEmbeddedPartitionManager();
        }
    }

    @Produces
    public PartitionManager producePartitionManager() {
        return this.partitionManager;
    }

    @Produces
    @RequestScoped
    public IdentityManager produceIdentityManager() {
        if (this.defaultPartition.isUnsatisfied() || this.defaultPartition.get() == null) {
            return new SecuredIdentityManager(this.partitionManager.createIdentityManager());
        }
        return new SecuredIdentityManager(this.partitionManager.createIdentityManager((Partition)this.defaultPartition.get()));
    }

    @Produces
    @RequestScoped
    public RelationshipManager produceRelationshipManager() {
        return this.partitionManager.createRelationshipManager();
    }

    @Produces
    @RequestScoped
    public PermissionManager producePermissionManager() {
        if (this.defaultPartition.isUnsatisfied() || this.defaultPartition.get() == null) {
            return this.partitionManager.createPermissionManager();
        }
        return this.partitionManager.createPermissionManager((Partition)this.defaultPartition.get());
    }

    private PartitionManager createEmbeddedPartitionManager() {
        if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
            BaseLog.ROOT_LOGGER.debugf("Creating PartitionManager.", new Object[0]);
        }
        List<IdentityConfiguration> identityConfiguration = this.identityManagementConfiguration.getIdentityConfiguration();
        DefaultPartitionManager partitionManager = new DefaultPartitionManager(identityConfiguration, (EventBridge)this.eventBridge, this.getPermissionHandlers());
        this.eventBridge.fireEvent(new PartitionManagerCreateEvent((PartitionManager)partitionManager));
        this.createDefaultPartition((PartitionManager)partitionManager);
        return partitionManager;
    }

    private void createDefaultPartition(PartitionManager partitionManager) {
        Realm defaultPartition = null;
        if (this.isPartitionSupported(partitionManager)) {
            if (partitionManager.getPartitions(Partition.class).isEmpty()) {
                if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                    BaseLog.ROOT_LOGGER.debugf("Creating default partition using [%s] and name [%s].", Realm.class, (Object)"default");
                }
                defaultPartition = new Realm("default");
                try {
                    partitionManager.add((AttributedType)defaultPartition);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create default partition. If you're using the JPA identity store, check if there is an active transaction.");
                }
            } else if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                BaseLog.ROOT_LOGGER.debugf("Found existing partitions. The default partition was not created.", new Object[0]);
            }
        }
        if (defaultPartition == null) {
            BaseLog.ROOT_LOGGER.warn((Object)"No default partition was created. You may want to create one before start managing your identity types.");
        }
    }

    private boolean isPartitionSupported(PartitionManager partitionManager) {
        for (IdentityConfiguration configuration : partitionManager.getConfigurations()) {
            if (!configuration.supportsPartition()) continue;
            for (IdentityStoreConfiguration storeConfig : configuration.getStoreConfiguration()) {
                if (!storeConfig.supportsType(Realm.class, IdentityStoreConfiguration.IdentityOperation.create)) continue;
                return true;
            }
        }
        return false;
    }

    private List<PermissionHandler> getPermissionHandlers() {
        ArrayList<PermissionHandler> permissionHandlers = new ArrayList<PermissionHandler>();
        if (!this.permissionHandlerInstance.isUnsatisfied()) {
            Iterator iterator = this.permissionHandlerInstance.iterator();
            while (iterator.hasNext()) {
                permissionHandlers.add((PermissionHandler)iterator.next());
            }
        }
        return permissionHandlers;
    }
}

