/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class DomainModelReferenceValidator
implements OperationStepHandler {
    private static DomainModelReferenceValidator INSTANCE = new DomainModelReferenceValidator();
    private static final OperationContext.AttachmentKey<DomainModelReferenceValidator> KEY = OperationContext.AttachmentKey.create(DomainModelReferenceValidator.class);

    private DomainModelReferenceValidator() {
    }

    public static void addValidationStep(OperationContext context, ModelNode operation) {
        assert (context.getProcessType() == ProcessType.HOST_CONTROLLER) : "Not a host controller";
        if (!context.isBooting() && context.attachIfAbsent(KEY, (Object)INSTANCE) == null) {
            context.addStep((OperationStepHandler)INSTANCE, OperationContext.Stage.MODEL);
        }
    }

    public static void validateAtBoot(OperationContext context, ModelNode operation) {
        assert (context.getProcessType() == ProcessType.HOST_CONTROLLER) : "Not a host controller";
        assert (context.isBooting()) : "Should only be called at boot";
        assert (operation.require("operation").asString().equals("validate"));
        if (context.attachIfAbsent(KEY, (Object)INSTANCE) == null) {
            context.addStep((OperationStepHandler)INSTANCE, OperationContext.Stage.MODEL);
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validate(context);
    }

    public void validate(OperationContext context) throws OperationFailedException {
        HashSet<String> serverGroups = new HashSet<String>();
        HashSet<String> interfaces = new HashSet<String>();
        Resource domain = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
        HashSet<String> missingProfiles = new HashSet<String>();
        HashSet<String> missingSocketBindingGroups = new HashSet<String>();
        Set<String> allProfiles = this.checkProfileIncludes(domain, missingProfiles);
        Set<String> allSocketBindingGroups = this.checkSocketBindingGroupIncludes(domain, missingSocketBindingGroups);
        String hostName = this.determineHostName(domain);
        if (hostName != null) {
            Resource host = domain.getChild(PathElement.pathElement((String)"host", (String)hostName));
            for (Resource.ResourceEntry serverConfig : host.getChildren("server-config")) {
                String defaultInterface;
                ModelNode model = serverConfig.getModel();
                String group = model.require("group").asString();
                if (!serverGroups.contains(group)) {
                    serverGroups.add(group);
                }
                if (model.hasDefined("socket-binding-default-interface") && !interfaces.contains(defaultInterface = model.get("socket-binding-default-interface").asString())) {
                    interfaces.add(defaultInterface);
                }
                this.processSocketBindingGroup(model, allSocketBindingGroups, missingSocketBindingGroups);
            }
        }
        for (Resource.ResourceEntry serverGroup : domain.getChildren("server-group")) {
            ModelNode model = serverGroup.getModel();
            String profile = model.require("profile").asString();
            if (!allProfiles.contains(profile)) {
                missingProfiles.add(profile);
            }
            this.processSocketBindingGroup(model, allSocketBindingGroups, missingSocketBindingGroups);
            serverGroups.remove(serverGroup.getName());
        }
        for (Resource.ResourceEntry iface : domain.getChildren("interface")) {
            interfaces.remove(iface.getName());
        }
        if (!serverGroups.isEmpty()) {
            throw ControllerLogger.ROOT_LOGGER.missingReferences("server-group", serverGroups);
        }
        if (!missingProfiles.isEmpty()) {
            throw ControllerLogger.ROOT_LOGGER.missingReferences("profile", missingProfiles);
        }
        if (!missingSocketBindingGroups.isEmpty()) {
            throw ControllerLogger.ROOT_LOGGER.missingReferences("socket-binding-group", missingSocketBindingGroups);
        }
        if (!interfaces.isEmpty()) {
            throw ControllerLogger.ROOT_LOGGER.missingReferences("interface", interfaces);
        }
    }

    private void processSocketBindingGroup(ModelNode model, Set<String> socketBindings, Set<String> missingSocketBindings) {
        String socketBinding;
        if (model.hasDefined("socket-binding-group") && !socketBindings.contains(socketBinding = model.require("socket-binding-group").asString())) {
            missingSocketBindings.add(socketBinding);
        }
    }

    private String determineHostName(Resource domain) {
        for (Resource.ResourceEntry entry : domain.getChildren("host")) {
            if (entry.isProxy() || entry.isRuntime()) continue;
            return entry.getName();
        }
        return null;
    }

    private Set<String> checkProfileIncludes(Resource domain, Set<String> missingProfiles) throws OperationFailedException {
        ProfileIncludeValidator validator = new ProfileIncludeValidator();
        for (Resource.ResourceEntry entry : domain.getChildren("profile")) {
            validator.processResource(entry);
        }
        validator.validate(missingProfiles);
        return validator.resourceIncludes.keySet();
    }

    private Set<String> checkSocketBindingGroupIncludes(Resource domain, Set<String> missingSocketBindingGroups) throws OperationFailedException {
        SocketBindingGroupIncludeValidator validator = new SocketBindingGroupIncludeValidator();
        for (Resource.ResourceEntry entry : domain.getChildren("socket-binding-group")) {
            validator.processResource(entry);
        }
        validator.validate(missingSocketBindingGroups);
        return new HashSet<String>(validator.resourceIncludes.keySet());
    }

    private static class SocketBindingGroupIncludeValidator
    extends AbstractIncludeValidator {
        private SocketBindingGroupIncludeValidator() {
        }

        @Override
        void processResource(Resource.ResourceEntry groupEntry) throws OperationFailedException {
            Set<String> bindings;
            super.processResource(groupEntry);
            if (groupEntry.hasChildren("socket-binding") || groupEntry.hasChildren("local-destination-outbound-socket-binding") || groupEntry.hasChildren("remote-destination-outbound-socket-binding")) {
                bindings = new HashSet<String>();
                this.addBindings(groupEntry, bindings, "socket-binding");
                this.addBindings(groupEntry, bindings, "local-destination-outbound-socket-binding");
                this.addBindings(groupEntry, bindings, "remote-destination-outbound-socket-binding");
                bindings.addAll(groupEntry.getChildrenNames("subsystem"));
            } else {
                bindings = Collections.emptySet();
            }
            this.resourceChildren.put(groupEntry.getName(), bindings);
        }

        private void addBindings(Resource.ResourceEntry groupEntry, Set<String> bindings, String bindingType) throws OperationFailedException {
            if (groupEntry.hasChildren(bindingType)) {
                for (String name : groupEntry.getChildrenNames(bindingType)) {
                    if (bindings.add(name)) continue;
                    throw ControllerLogger.ROOT_LOGGER.bindingNameNotUnique(name, groupEntry.getName());
                }
            }
        }

        @Override
        OperationFailedException profileAttemptingToOverrideSubsystem(String existingSubsystemProfile, String child, String resourceName) {
            return ControllerLogger.ROOT_LOGGER.socketBindingGroupAttemptingToOverrideSocketBinding(existingSubsystemProfile, child, resourceName);
        }

        @Override
        OperationFailedException profileInvolvedInACycle(String include) {
            return ControllerLogger.ROOT_LOGGER.socketBindingGroupInvolvedInACycle(include);
        }
    }

    private static class ProfileIncludeValidator
    extends AbstractIncludeValidator {
        private ProfileIncludeValidator() {
        }

        @Override
        void processResource(Resource.ResourceEntry profileEntry) throws OperationFailedException {
            Set subsystems;
            super.processResource(profileEntry);
            if (profileEntry.hasChildren("subsystem")) {
                subsystems = new HashSet();
                subsystems.addAll(profileEntry.getChildrenNames("subsystem"));
            } else {
                subsystems = Collections.emptySet();
            }
            this.resourceChildren.put(profileEntry.getName(), subsystems);
        }

        @Override
        OperationFailedException profileAttemptingToOverrideSubsystem(String existingSubsystemProfile, String child, String resourceName) {
            return ControllerLogger.ROOT_LOGGER.profileAttemptingToOverrideSubsystem(existingSubsystemProfile, child, resourceName);
        }

        @Override
        OperationFailedException profileInvolvedInACycle(String include) {
            return ControllerLogger.ROOT_LOGGER.profileInvolvedInACycle(include);
        }
    }

    private static abstract class AbstractIncludeValidator {
        protected final Set<String> seen = new HashSet<String>();
        protected final Set<String> onStack = new HashSet<String>();
        protected final Map<String, String> linkTo = new HashMap<String, String>();
        protected final Map<String, Set<String>> resourceIncludes = new HashMap<String, Set<String>>();
        protected final Map<String, Set<String>> resourceChildren = new HashMap<String, Set<String>>();
        protected final List<String> post = new ArrayList<String>();

        private AbstractIncludeValidator() {
        }

        void processResource(Resource.ResourceEntry resourceEntry) throws OperationFailedException {
            Set includes;
            ModelNode model = resourceEntry.getModel();
            if (model.hasDefined("includes")) {
                includes = new HashSet();
                for (ModelNode include : model.get("includes").asList()) {
                    includes.add(include.asString());
                }
            } else {
                includes = Collections.emptySet();
            }
            this.resourceIncludes.put(resourceEntry.getName(), includes);
        }

        void validate(Set<String> missingEntries) throws OperationFailedException {
            for (String profileName : this.resourceIncludes.keySet()) {
                if (this.seen.contains(profileName)) continue;
                this.dfsForMissingOrCyclicIncludes(profileName, missingEntries);
            }
            if (missingEntries.size() > 0) {
                return;
            }
            this.seen.clear();
            ListIterator<String> it = this.post.listIterator(this.post.size());
            while (it.hasPrevious()) {
                String profile = it.previous();
                if (this.seen.contains(profile)) continue;
                HashMap<String, String> subsystems = new HashMap<String, String>();
                this.validateChildrenNotOverridden(profile, subsystems);
            }
        }

        void validateChildrenNotOverridden(String resourceName, Map<String, String> children) throws OperationFailedException {
            this.seen.add(resourceName);
            Set<String> includes = this.resourceIncludes.get(resourceName);
            if (includes.size() == 0 && children.size() == 0) {
                return;
            }
            for (String child : this.resourceChildren.get(resourceName)) {
                String existingSubsystemProfile = children.get(child);
                if (existingSubsystemProfile != null) {
                    throw this.profileAttemptingToOverrideSubsystem(existingSubsystemProfile, child, resourceName);
                }
                children.put(child, resourceName);
            }
            for (String include : includes) {
                this.validateChildrenNotOverridden(include, children);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dfsForMissingOrCyclicIncludes(String resourceName, Set<String> missingEntries) throws OperationFailedException {
            this.onStack.add(resourceName);
            try {
                this.seen.add(resourceName);
                Set<String> includes = this.resourceIncludes.get(resourceName);
                if (includes == null) {
                    missingEntries.add(resourceName);
                    return;
                }
                for (String include : includes) {
                    if (!this.seen.contains(include)) {
                        this.linkTo.put(include, resourceName);
                        this.dfsForMissingOrCyclicIncludes(include, missingEntries);
                        continue;
                    }
                    if (!this.onStack.contains(include)) continue;
                    throw this.profileInvolvedInACycle(include);
                }
            }
            finally {
                this.onStack.remove(resourceName);
            }
            this.post.add(resourceName);
        }

        abstract OperationFailedException profileAttemptingToOverrideSubsystem(String var1, String var2, String var3);

        abstract OperationFailedException profileInvolvedInACycle(String var1);
    }
}

