/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.WritableEntry;
import org.jboss.classfilewriter.annotations.AnnotationsAttribute;
import org.jboss.classfilewriter.attributes.Attribute;
import org.jboss.classfilewriter.attributes.SignatureAttribute;
import org.jboss.classfilewriter.constpool.ConstPool;
import org.jboss.classfilewriter.util.ByteArrayDataOutputStream;

public class ClassField
implements WritableEntry {
    private final short accessFlags;
    private final String name;
    private final short nameIndex;
    private final String descriptor;
    private final short descriptorIndex;
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private final ClassFile classFile;
    private final AnnotationsAttribute runtimeVisibleAnnotationsAttribute;
    private SignatureAttribute signatureAttribute;
    private String signature;

    ClassField(short accessFlags, String name, String descriptor, ClassFile classFile, ConstPool constPool) {
        this.accessFlags = accessFlags;
        this.name = name;
        this.descriptor = descriptor;
        this.classFile = classFile;
        this.nameIndex = constPool.addUtf8Entry(name);
        this.descriptorIndex = constPool.addUtf8Entry(descriptor);
        this.runtimeVisibleAnnotationsAttribute = new AnnotationsAttribute(AnnotationsAttribute.Type.RUNTIME_VISIBLE, constPool);
        this.attributes.add(this.runtimeVisibleAnnotationsAttribute);
    }

    @Override
    public void write(ByteArrayDataOutputStream stream) throws IOException {
        if (this.signatureAttribute != null) {
            this.attributes.add(this.signatureAttribute);
        }
        stream.writeShort(this.accessFlags);
        stream.writeShort(this.nameIndex);
        stream.writeShort(this.descriptorIndex);
        stream.writeShort(this.attributes.size());
        for (Attribute attribute : this.attributes) {
            attribute.write(stream);
        }
    }

    public short getAccessFlags() {
        return this.accessFlags;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signatureAttribute = signature == null ? null : new SignatureAttribute(this.classFile.getConstPool(), signature);
        this.signature = signature;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.descriptor == null ? 0 : this.descriptor.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassField other = (ClassField)obj;
        if (this.descriptor == null ? other.descriptor != null : !this.descriptor.equals(other.descriptor)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public AnnotationsAttribute getRuntimeVisibleAnnotationsAttribute() {
        return this.runtimeVisibleAnnotationsAttribute;
    }
}

