/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;

public class StompFrame {
    private static final byte[] END_OF_FRAME = new byte[]{0, 10};
    protected final String command;
    protected final Map<String, String> headers;
    private String body;
    protected byte[] bytesBody;
    protected ActiveMQBuffer buffer = null;
    protected int size;
    private boolean disconnect;
    private boolean isPing;

    public StompFrame(String command) {
        this(command, false);
    }

    public StompFrame(String command, boolean disconnect) {
        this.command = command;
        this.headers = new LinkedHashMap<String, String>();
        this.disconnect = disconnect;
    }

    public StompFrame(String command, Map<String, String> headers, byte[] content) {
        this.command = command;
        this.headers = headers;
        this.bytesBody = content;
    }

    public String getCommand() {
        return this.command;
    }

    public int getEncodedSize() throws Exception {
        if (this.buffer == null) {
            this.buffer = this.toActiveMQBuffer();
        }
        return this.size;
    }

    public String toString() {
        return "StompFrame[command=" + this.command + ", headers=" + this.headers + ", content= " + this.body + " bytes " + Arrays.toString(this.bytesBody);
    }

    public boolean isPing() {
        return this.isPing;
    }

    public void setPing(boolean ping) {
        this.isPing = ping;
    }

    public ActiveMQBuffer toActiveMQBuffer() throws Exception {
        if (this.buffer == null) {
            this.buffer = this.bytesBody != null ? ActiveMQBuffers.dynamicBuffer((int)(this.bytesBody.length + 512)) : ActiveMQBuffers.dynamicBuffer((int)512);
            if (this.isPing()) {
                this.buffer.writeByte((byte)10);
                return this.buffer;
            }
            StringBuffer head = new StringBuffer();
            head.append(this.command);
            head.append("\n");
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                head.append(header.getKey());
                head.append(":");
                head.append(header.getValue());
                head.append("\n");
            }
            head.append("\n");
            this.buffer.writeBytes(head.toString().getBytes(StandardCharsets.UTF_8));
            if (this.bytesBody != null) {
                this.buffer.writeBytes(this.bytesBody);
            }
            this.buffer.writeBytes(END_OF_FRAME);
            this.size = this.buffer.writerIndex();
        } else {
            this.buffer.readerIndex(0);
        }
        return this.buffer;
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public void addHeader(String key, String val) {
        this.headers.put(key, val);
    }

    public Map<String, String> getHeadersMap() {
        return this.headers;
    }

    public String encode(String str) {
        int len = str.length();
        char[] buffer = new char[2 * len];
        int iBuffer = 0;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                buffer[iBuffer] = 92;
                buffer[++iBuffer] = 110;
            } else if (c == '\r') {
                buffer[iBuffer] = 92;
                buffer[++iBuffer] = 114;
            } else if (c == '\\') {
                buffer[iBuffer] = 92;
                buffer[++iBuffer] = 92;
            } else if (c == ':') {
                buffer[iBuffer] = 92;
                buffer[++iBuffer] = 99;
            } else {
                buffer[iBuffer] = c;
            }
            ++iBuffer;
        }
        char[] total = new char[iBuffer];
        System.arraycopy(buffer, 0, total, 0, iBuffer);
        return new String(total);
    }

    public void setBody(String body) {
        this.body = body;
        this.bytesBody = body.getBytes(StandardCharsets.UTF_8);
    }

    public boolean hasHeader(String key) {
        return this.headers.containsKey(key);
    }

    public String getBody() {
        if (this.body == null && this.bytesBody != null) {
            this.body = new String(this.bytesBody, StandardCharsets.UTF_8);
        }
        return this.body;
    }

    public byte[] getBodyAsBytes() {
        return this.bytesBody;
    }

    public boolean needsDisconnect() {
        return this.disconnect;
    }

    public void setByteBody(byte[] content) {
        this.bytesBody = content;
    }

    public void setNeedsDisconnect(boolean b) {
        this.disconnect = b;
    }

    public class Header {
        public String key;
        public String val;

        public Header(String key, String val) {
            this.key = key;
            this.val = val;
        }

        public String getEncodedKey() {
            return StompFrame.this.encode(this.key);
        }

        public String getEncodedValue() {
            return StompFrame.this.encode(this.val);
        }
    }
}

