/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.impl;

import java.util.Map;
import javax.xml.namespace.QName;
import org.joda.time.ReadableInstant;
import org.opensaml.Configuration;
import org.opensaml.common.impl.AbstractSAMLObjectMarshaller;
import org.opensaml.saml2.metadata.AffiliationDescriptor;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AffiliationDescriptorMarshaller
extends AbstractSAMLObjectMarshaller {
    private final Logger log = LoggerFactory.getLogger(AffiliationDescriptorMarshaller.class);

    @Override
    protected void marshallAttributes(XMLObject samlElement, Element domElement) throws MarshallingException {
        AffiliationDescriptor descriptor = (AffiliationDescriptor)samlElement;
        if (descriptor.getOwnerID() != null) {
            domElement.setAttributeNS(null, "affiliationOwnerID", descriptor.getOwnerID());
        }
        if (descriptor.getID() != null) {
            domElement.setAttributeNS(null, "ID", descriptor.getID());
            domElement.setIdAttributeNS(null, "ID", true);
        }
        if (descriptor.getValidUntil() != null) {
            this.log.debug("Writting validUntil attribute to AffiliationDescriptor DOM element");
            String validUntilStr = Configuration.getSAMLDateFormatter().print((ReadableInstant)descriptor.getValidUntil());
            domElement.setAttributeNS(null, "validUntil", validUntilStr);
        }
        if (descriptor.getCacheDuration() != null) {
            this.log.debug("Writting cacheDuration attribute to AffiliationDescriptor DOM element");
            String cacheDuration = XMLHelper.longToDuration((long)descriptor.getCacheDuration());
            domElement.setAttributeNS(null, "cacheDuration", cacheDuration);
        }
        for (Map.Entry entry : descriptor.getUnknownAttributes().entrySet()) {
            Attr attribute = XMLHelper.constructAttribute((Document)domElement.getOwnerDocument(), (QName)((QName)entry.getKey()));
            attribute.setValue((String)entry.getValue());
            domElement.setAttributeNodeNS(attribute);
            if (!Configuration.isIDAttribute((QName)((QName)entry.getKey())) && !descriptor.getUnknownAttributes().isIDAttribute((QName)entry.getKey())) continue;
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        }
    }
}

