/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.validator;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.token.realm.CertConstraintsParser;
import org.apache.cxf.sts.token.validator.TokenValidator;
import org.apache.cxf.sts.token.validator.TokenValidatorParameters;
import org.apache.cxf.sts.token.validator.TokenValidatorResponse;
import org.apache.cxf.ws.security.sts.provider.model.secext.BinarySecurityTokenType;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.apache.wss4j.dom.message.token.X509Security;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.SignatureTrustValidator;
import org.apache.wss4j.dom.validate.Validator;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class X509TokenValidator
implements TokenValidator {
    public static final String X509_V3_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    public static final String BASE64_ENCODING = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    private static final Logger LOG = LogUtils.getL7dLogger(X509TokenValidator.class);
    private Validator validator = new SignatureTrustValidator();
    private CertConstraintsParser certConstraints = new CertConstraintsParser();

    public void setSubjectConstraints(List<String> subjectConstraints) {
        this.certConstraints.setSubjectConstraints(subjectConstraints);
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    @Override
    public boolean canHandleToken(ReceivedToken validateTarget) {
        return this.canHandleToken(validateTarget, null);
    }

    @Override
    public boolean canHandleToken(ReceivedToken validateTarget, String realm) {
        Object token = validateTarget.getToken();
        if (token instanceof BinarySecurityTokenType && X509_V3_TYPE.equals(((BinarySecurityTokenType)token).getValueType())) {
            return true;
        }
        return token instanceof Element && "http://www.w3.org/2000/09/xmldsig#".equals(((Element)token).getNamespaceURI()) && "X509Data".equals(((Element)token).getLocalName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TokenValidatorResponse validateToken(TokenValidatorParameters tokenParameters) {
        LOG.fine("Validating X.509 Token");
        STSPropertiesMBean stsProperties = tokenParameters.getStsProperties();
        Crypto sigCrypto = stsProperties.getSignatureCrypto();
        CallbackHandler callbackHandler = stsProperties.getCallbackHandler();
        RequestData requestData = new RequestData();
        requestData.setSigVerCrypto(sigCrypto);
        requestData.setWssConfig(WSSConfig.getNewInstance());
        requestData.setCallbackHandler(callbackHandler);
        requestData.setMsgContext((Object)tokenParameters.getWebServiceContext().getMessageContext());
        requestData.setSubjectCertConstraints(this.certConstraints.getCompiledSubjectContraints());
        TokenValidatorResponse response = new TokenValidatorResponse();
        ReceivedToken validateTarget = tokenParameters.getToken();
        validateTarget.setState(ReceivedToken.STATE.INVALID);
        response.setToken(validateTarget);
        X509Security binarySecurity = null;
        if (validateTarget.isBinarySecurityToken()) {
            BinarySecurityTokenType binarySecurityType = (BinarySecurityTokenType)validateTarget.getToken();
            String encodingType = binarySecurityType.getEncodingType();
            if (!BASE64_ENCODING.equals(encodingType)) {
                LOG.fine("Bad encoding type attribute specified: " + encodingType);
                return response;
            }
            Document doc = DOMUtils.createDocument();
            binarySecurity = new X509Security(doc);
            binarySecurity.setEncodingType(encodingType);
            binarySecurity.setValueType(binarySecurityType.getValueType());
            String data = binarySecurityType.getValue();
            ((Text)binarySecurity.getElement().getFirstChild()).setData(data);
        } else {
            if (!validateTarget.isDOMElement()) return response;
            try {
                Document doc = DOMUtils.createDocument();
                binarySecurity = new X509Security(doc);
                binarySecurity.setEncodingType(BASE64_ENCODING);
                X509Data x509Data = new X509Data((Element)validateTarget.getToken(), "");
                if (x509Data.containsCertificate()) {
                    X509Certificate cert = x509Data.itemCertificate(0).getX509Certificate();
                    binarySecurity.setX509Certificate(cert);
                }
            }
            catch (WSSecurityException ex) {
                LOG.log(Level.WARNING, "", ex);
                return response;
            }
            catch (XMLSecurityException ex) {
                LOG.log(Level.WARNING, "", ex);
                return response;
            }
        }
        try {
            Credential returnedCredential;
            Principal principal;
            Credential credential = new Credential();
            credential.setBinarySecurityToken((BinarySecurity)binarySecurity);
            if (sigCrypto != null) {
                X509Certificate cert = binarySecurity.getX509Certificate(sigCrypto);
                credential.setCertificates(new X509Certificate[]{cert});
            }
            if ((principal = (returnedCredential = this.validator.validate(credential, requestData)).getPrincipal()) == null) {
                principal = returnedCredential.getCertificates()[0].getSubjectX500Principal();
            }
            response.setPrincipal(principal);
            validateTarget.setState(ReceivedToken.STATE.VALID);
            LOG.fine("X.509 Token successfully validated");
            return response;
        }
        catch (WSSecurityException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
        return response;
    }
}

