/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.SelectionKey;
import org.xnio.Bits;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioUdpChannel;
import org.xnio.nio.WorkerThread;

final class NioUdpChannelHandle
extends NioHandle {
    private final NioUdpChannel channel;

    NioUdpChannelHandle(WorkerThread workerThread, SelectionKey selectionKey, NioUdpChannel channel) {
        super(workerThread, selectionKey);
        this.channel = channel;
    }

    @Override
    void handleReady(int ops) {
        try {
            if (ops == 0) {
                SelectionKey key = this.getSelectionKey();
                int interestOps = key.interestOps();
                if (interestOps != 0) {
                    ops = interestOps;
                } else {
                    this.forceTermination();
                    return;
                }
            }
            if (Bits.allAreSet((int)ops, (int)1)) {
                try {
                    ChannelListeners.invokeChannelListener((Channel)((Object)this.channel), this.channel.getReadListener());
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
            if (Bits.allAreSet((int)ops, (int)4)) {
                try {
                    ChannelListeners.invokeChannelListener((Channel)((Object)this.channel), this.channel.getWriteListener());
                }
                catch (Throwable ignored) {}
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    void forceTermination() {
        IoUtils.safeClose((Closeable)((Object)this.channel));
    }

    @Override
    void terminated() {
        this.channel.invokeCloseHandler();
    }
}

