/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl.dataformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.journal.impl.dataformat.JournalInternalRecord;

public class JournalAddRecordTX
extends JournalInternalRecord {
    private final long txID;
    private final long id;
    private final EncodingSupport record;
    private final byte recordType;
    private final boolean add;

    public JournalAddRecordTX(boolean add, long txID, long id, byte recordType, EncodingSupport record) {
        this.txID = txID;
        this.id = id;
        this.record = record;
        this.recordType = recordType;
        this.add = add;
    }

    @Override
    public void encode(HornetQBuffer buffer) {
        if (this.add) {
            buffer.writeByte((byte)13);
        } else {
            buffer.writeByte((byte)14);
        }
        buffer.writeInt(this.fileID);
        buffer.writeByte(this.compactCount);
        buffer.writeLong(this.txID);
        buffer.writeLong(this.id);
        buffer.writeInt(this.record.getEncodeSize());
        buffer.writeByte(this.recordType);
        this.record.encode(buffer);
        buffer.writeInt(this.getEncodeSize());
    }

    @Override
    public int getEncodeSize() {
        return 30 + this.record.getEncodeSize() + 1;
    }
}

