/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.api.InstanceFactory;
import io.undertow.util.PathTemplate;
import io.undertow.websockets.jsr.EncodingFactory;
import io.undertow.websockets.jsr.annotated.AnnotatedEndpointFactory;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpointConfig;

public class ConfiguredServerEndpoint {
    private final ServerEndpointConfig endpointConfiguration;
    private final AnnotatedEndpointFactory annotatedEndpointFactory;
    private final InstanceFactory<?> endpointFactory;
    private final PathTemplate pathTemplate;
    private final EncodingFactory encodingFactory;
    private final Set<Session> openSessions = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile int waiterCount;

    public ConfiguredServerEndpoint(ServerEndpointConfig endpointConfiguration, InstanceFactory<?> endpointFactory, PathTemplate pathTemplate, EncodingFactory encodingFactory, AnnotatedEndpointFactory annotatedEndpointFactory) {
        this.endpointConfiguration = endpointConfiguration;
        this.endpointFactory = endpointFactory;
        this.pathTemplate = pathTemplate;
        this.encodingFactory = encodingFactory;
        this.annotatedEndpointFactory = annotatedEndpointFactory;
    }

    public ServerEndpointConfig getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public InstanceFactory<?> getEndpointFactory() {
        return this.endpointFactory;
    }

    public PathTemplate getPathTemplate() {
        return this.pathTemplate;
    }

    public EncodingFactory getEncodingFactory() {
        return this.encodingFactory;
    }

    public Set<Session> getOpenSessions() {
        return this.openSessions;
    }

    public void addOpenSession(Session session) {
        this.openSessions.add(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOpenSession(Session session) {
        ConfiguredServerEndpoint configuredServerEndpoint = this;
        synchronized (configuredServerEndpoint) {
            this.openSessions.remove(session);
            if (this.waiterCount > 0 && this.openSessions.isEmpty()) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void awaitClose(long timeout) {
        ++this.waiterCount;
        long end = System.currentTimeMillis() + timeout;
        ConfiguredServerEndpoint configuredServerEndpoint = this;
        synchronized (configuredServerEndpoint) {
            if (this.openSessions.isEmpty()) {
                return;
            }
            try {
                while (System.currentTimeMillis() < end) {
                    this.wait(end - System.currentTimeMillis());
                }
                --this.waiterCount;
            }
            catch (InterruptedException e) {
                --this.waiterCount;
                return;
                catch (Throwable throwable) {
                    --this.waiterCount;
                    throw throwable;
                }
            }
        }
    }

    public AnnotatedEndpointFactory getAnnotatedEndpointFactory() {
        return this.annotatedEndpointFactory;
    }
}

