/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.hibernate.search.cfg.AnalyzerDefMapping;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.FieldMapping;
import org.hibernate.search.cfg.PropertyDescriptor;
import org.hibernate.search.cfg.PropertyMapping;
import org.hibernate.search.cfg.SearchMapping;

public class IndexEmbeddedMapping {
    private final SearchMapping mapping;
    private final Map<String, Object> indexEmbedded;
    private final EntityDescriptor entity;
    private final PropertyDescriptor property;

    public IndexEmbeddedMapping(SearchMapping mapping, PropertyDescriptor property, EntityDescriptor entity) {
        this.mapping = mapping;
        this.indexEmbedded = new HashMap<String, Object>();
        this.property = property;
        this.entity = entity;
        this.property.setIndexEmbedded(this.indexEmbedded);
    }

    public IndexEmbeddedMapping prefix(String prefix) {
        this.indexEmbedded.put("prefix", prefix);
        return this;
    }

    public IndexEmbeddedMapping targetElement(Class<?> targetElement) {
        this.indexEmbedded.put("targetElement", targetElement);
        return this;
    }

    public IndexEmbeddedMapping depth(int depth) {
        this.indexEmbedded.put("depth", depth);
        return this;
    }

    public IndexEmbeddedMapping includeEmbeddedObjectId(boolean includeEmbeddedObjectId) {
        this.indexEmbedded.put("includeEmbeddedObjectId", includeEmbeddedObjectId);
        return this;
    }

    public IndexEmbeddedMapping indexNullAs(String nullToken) {
        this.indexEmbedded.put("indexNullAs", nullToken);
        return this;
    }

    public IndexEmbeddedMapping includePaths(String firstPath, String ... furtherPaths) {
        this.indexEmbedded.put("includePaths", this.merge(firstPath, furtherPaths));
        return this;
    }

    private String[] merge(String firstPath, String ... furtherPaths) {
        if (furtherPaths == null) {
            return new String[]{firstPath};
        }
        String[] paths = new String[1 + furtherPaths.length];
        paths[0] = firstPath;
        System.arraycopy(furtherPaths, 0, paths, 1, furtherPaths.length);
        return paths;
    }

    public PropertyMapping property(String name, ElementType type) {
        return new PropertyMapping(name, type, this.entity, this.mapping);
    }

    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerFactory, this.mapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.mapping);
    }

    public FieldMapping field() {
        return new FieldMapping(this.property, this.entity, this.mapping);
    }
}

