/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.UndertowOptions;
import io.undertow.server.OpenListener;
import io.undertow.server.protocol.ajp.AjpOpenListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.service.StartContext;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;

public class AjpListenerService
extends ListenerService<AjpListenerService> {
    private volatile AcceptingChannel<StreamConnection> server;
    private final String scheme;

    public AjpListenerService(String name, String scheme, OptionMap listenerOptions, OptionMap socketOptions) {
        super(name, listenerOptions, socketOptions);
        this.scheme = scheme;
    }

    @Override
    protected OpenListener createOpenListener() {
        AjpOpenListener ajpOpenListener = new AjpOpenListener((Pool)this.getBufferPool().getValue(), OptionMap.builder().addAll(commonOptions).addAll(this.listenerOptions).set(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, this.getUndertowService().isStatisticsEnabled()).getMap());
        ajpOpenListener.setScheme(this.scheme);
        return ajpOpenListener;
    }

    @Override
    void startListening(XnioWorker worker, InetSocketAddress socketAddress, ChannelListener<AcceptingChannel<StreamConnection>> acceptListener) throws IOException {
        this.server = worker.createStreamConnectionServer((SocketAddress)socketAddress, acceptListener, OptionMap.builder().addAll(commonOptions).addAll(this.socketOptions).getMap());
        this.server.resumeAccepts();
        UndertowLogger.ROOT_LOGGER.listenerStarted("AJP", this.getName(), ((SocketBinding)this.binding.getValue()).getSocketAddress());
    }

    @Override
    protected void cleanFailedStart() {
    }

    @Override
    void stopListening() {
        this.server.suspendAccepts();
        UndertowLogger.ROOT_LOGGER.listenerSuspend("AJP", this.getName());
        IoUtils.safeClose(this.server);
        UndertowLogger.ROOT_LOGGER.listenerStopped("AJP", this.getName(), ((SocketBinding)this.getBinding().getValue()).getSocketAddress());
    }

    public AjpListenerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public boolean isSecure() {
        return this.scheme != null && this.scheme.equals("https");
    }

    @Override
    protected void preStart(StartContext context) {
    }

    @Override
    protected String getProtocol() {
        return "ajp";
    }
}

