/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.ConnectorStatistics;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;

public class ResetConnectorStatisticsHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "reset-statistics";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("reset-statistics", (ResourceDescriptionResolver)UndertowExtension.getResolver("listener")).setRuntimeOnly().build();
    public static final ResetConnectorStatisticsHandler INSTANCE = new ResetConnectorStatisticsHandler();

    private ResetConnectorStatisticsHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ListenerService service = (ListenerService)context.getServiceRegistry(false).getService(UndertowService.listenerName(name)).getValue();
        ConnectorStatistics stats = service.getOpenListener().getConnectorStatistics();
        if (stats != null) {
            stats.reset();
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }
}

