/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.XmlElement;
import org.jgroups.annotations.XmlInclude;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.fork.ForkConfig;
import org.jgroups.fork.ForkProtocol;
import org.jgroups.fork.ForkProtocolStack;
import org.jgroups.fork.UnknownForkHandler;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Bits;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;
import org.w3c.dom.Node;

@XmlInclude(schema={"fork-stacks.xsd"}, type=XmlInclude.Type.IMPORT, namespace="fork", alias="fork")
@XmlElement(name="fork-stacks", type="fork:ForkStacksType")
@MBean(description="Implementation of FORK protocol")
public class FORK
extends Protocol {
    public static short ID = ClassConfigurator.getProtocolId(FORK.class);
    @Property(description="Points to an XML file defining the fork-stacks, which will be created at initialization. Ignored if null")
    protected String config;
    private UnknownForkHandler unknownForkHandler = new UnknownForkHandler(){

        @Override
        public Object handleUnknownForkStack(Message message, String forkStackId) {
            FORK.this.log.warn("fork-stack for id=%s not found; discarding message", forkStackId);
            return null;
        }

        @Override
        public Object handleUnknownForkChannel(Message message, String forkChannelId) {
            FORK.this.log.warn("fork-channel for id=%s not found; discarding message", forkChannelId);
            return null;
        }
    };
    protected final ConcurrentMap<String, Protocol> fork_stacks = new ConcurrentHashMap<String, Protocol>();

    public void setUnknownForkHandler(UnknownForkHandler unknownForkHandler) {
        this.unknownForkHandler = unknownForkHandler;
    }

    public UnknownForkHandler getUnknownForkHandler() {
        return this.unknownForkHandler;
    }

    public Protocol get(String fork_stack_id) {
        return (Protocol)this.fork_stacks.get(fork_stack_id);
    }

    public Protocol putIfAbsent(String fork_stack_id, Protocol prot) {
        return this.fork_stacks.put(fork_stack_id, prot);
    }

    public void remove(String fork_stack_id) {
        this.fork_stacks.remove(fork_stack_id);
    }

    @ManagedAttribute(description="Number of fork-stacks")
    public int getForkStacks() {
        return this.fork_stacks.size();
    }

    public static ForkProtocolStack getForkStack(Protocol prot) {
        while (prot != null && !(prot instanceof ForkProtocolStack)) {
            prot = prot.getUpProtocol();
        }
        return prot instanceof ForkProtocolStack ? (ForkProtocolStack)prot : null;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.config != null) {
            this.createForkStacks(this.config);
        }
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                ForkHeader hdr = (ForkHeader)msg.getHeader(this.id);
                if (hdr == null) break;
                if (hdr.fork_stack_id == null) {
                    throw new IllegalArgumentException("header has a null fork_stack_id");
                }
                Protocol bottom_prot = this.get(hdr.fork_stack_id);
                return bottom_prot != null ? bottom_prot.up(evt) : this.unknownForkHandler.handleUnknownForkStack(msg, hdr.fork_stack_id);
            }
            case 6: {
                for (Protocol bottom : this.fork_stacks.values()) {
                    bottom.up(evt);
                }
                break;
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void up(MessageBatch batch) {
        ArrayList<Message> list;
        HashMap<String, ArrayList<Message>> map = new HashMap<String, ArrayList<Message>>();
        for (Message message : batch) {
            ForkHeader hdr = (ForkHeader)message.getHeader(this.id);
            if (hdr == null) continue;
            batch.remove(message);
            list = (List)map.get(hdr.fork_stack_id);
            if (list == null) {
                list = new ArrayList<Message>();
                map.put(hdr.fork_stack_id, list);
            }
            list.add(message);
        }
        for (Map.Entry entry : map.entrySet()) {
            String fork_stack_id = (String)entry.getKey();
            list = (ArrayList<Message>)entry.getValue();
            Protocol bottom_prot = this.get(fork_stack_id);
            if (bottom_prot == null) continue;
            MessageBatch mb = new MessageBatch(batch.dest(), batch.sender(), batch.clusterName(), batch.multicast(), list);
            try {
                bottom_prot.up(mb);
            }
            catch (Throwable t) {
                this.log.error("failed passing up batch", t);
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void createForkStacks(String config) throws Exception {
        InputStream in = FORK.getForkStream(config);
        if (in == null) {
            throw new FileNotFoundException("fork stacks config " + config + " not found");
        }
        Map<String, List<ProtocolConfiguration>> protocols = ForkConfig.parse(in);
        this.createForkStacks(protocols);
    }

    protected void createForkStacks(Map<String, List<ProtocolConfiguration>> protocols) throws Exception {
        for (Map.Entry<String, List<ProtocolConfiguration>> entry : protocols.entrySet()) {
            String fork_stack_id = entry.getKey();
            if (this.get(fork_stack_id) != null) continue;
            List<Protocol> prots = FORK.createProtocols(null, entry.getValue());
            this.createForkStack(fork_stack_id, prots, false);
        }
    }

    @Override
    public void parse(Node node) throws Exception {
        Map<String, List<ProtocolConfiguration>> protocols = ForkConfig.parse(node);
        this.createForkStacks(protocols);
    }

    public synchronized ProtocolStack createForkStack(String fork_stack_id, List<Protocol> protocols, boolean initialize) throws Exception {
        Protocol bottom = this.get(fork_stack_id);
        if (bottom != null) {
            ForkProtocolStack retval = FORK.getForkStack(bottom);
            return initialize ? retval.incrInits() : retval;
        }
        ArrayList<Protocol> prots = new ArrayList<Protocol>();
        bottom = new ForkProtocol(fork_stack_id).setDownProtocol(this);
        prots.add(bottom);
        if (protocols != null) {
            prots.addAll(protocols);
        }
        ForkProtocolStack fork_stack = (ForkProtocolStack)new ForkProtocolStack(this.getUnknownForkHandler(), prots, fork_stack_id).setChannel(this.stack.getChannel());
        fork_stack.init();
        if (initialize) {
            fork_stack.incrInits();
        }
        this.fork_stacks.put(fork_stack_id, bottom);
        return fork_stack;
    }

    protected static List<Protocol> createProtocols(ProtocolStack stack, List<ProtocolConfiguration> protocol_configs) throws Exception {
        return Configurator.createProtocols(protocol_configs, stack);
    }

    public static InputStream getForkStream(String config) throws IOException {
        InputStream configStream = null;
        try {
            configStream = new FileInputStream(config);
        }
        catch (FileNotFoundException | AccessControlException fnfe) {
            // empty catch block
        }
        if (configStream == null) {
            try {
                configStream = new URL(config).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (configStream == null) {
            configStream = Util.getResourceAsStream(config, ConfiguratorFactory.class);
        }
        return configStream;
    }

    public static class ForkHeader
    extends Header {
        protected String fork_stack_id;
        protected String fork_channel_id;

        public ForkHeader() {
        }

        public ForkHeader(String fork_stack_id, String fork_channel_id) {
            this.fork_stack_id = fork_stack_id;
            this.fork_channel_id = fork_channel_id;
        }

        public String getForkStackId() {
            return this.fork_stack_id;
        }

        public void setForkStackId(String fork_stack_id) {
            this.fork_stack_id = fork_stack_id;
        }

        public String getForkChannelId() {
            return this.fork_channel_id;
        }

        public void setForkChannelId(String fork_channel_id) {
            this.fork_channel_id = fork_channel_id;
        }

        @Override
        public int size() {
            return Util.size(this.fork_stack_id) + Util.size(this.fork_channel_id);
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            Bits.writeString(this.fork_stack_id, out);
            Bits.writeString(this.fork_channel_id, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.fork_stack_id = Bits.readString(in);
            this.fork_channel_id = Bits.readString(in);
        }

        @Override
        public String toString() {
            return this.fork_stack_id + ":" + this.fork_channel_id;
        }
    }
}

