/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PropertiesLoaderUtils {
    private PropertiesLoaderUtils() {
    }

    public static Properties loadAllProperties(String resourceName, ClassLoader classLoader) throws IOException {
        return PropertiesLoaderUtils.loadAllProperties(resourceName, classLoader, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadAllProperties(String resourceName, ClassLoader classLoader, Logger logger, Level level, String msg) throws IOException {
        Properties properties = new Properties();
        if (classLoader == null) {
            classLoader = PropertiesLoaderUtils.class.getClassLoader();
        }
        Enumeration<URL> urls = classLoader.getResources(resourceName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (logger != null) {
                logger.log(level, msg, url.toString());
            }
            InputStream is = null;
            try {
                is = url.openStream();
                properties.loadFromXML(new BufferedInputStream(is));
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return properties;
    }
}

