/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.internal;

import org.hibernate.HibernateException;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.event.spi.EnversListenerDuplicationStrategy;
import org.hibernate.envers.event.spi.EnversPostCollectionRecreateEventListenerImpl;
import org.hibernate.envers.event.spi.EnversPostDeleteEventListenerImpl;
import org.hibernate.envers.event.spi.EnversPostInsertEventListenerImpl;
import org.hibernate.envers.event.spi.EnversPostUpdateEventListenerImpl;
import org.hibernate.envers.event.spi.EnversPreCollectionRemoveEventListenerImpl;
import org.hibernate.envers.event.spi.EnversPreCollectionUpdateEventListenerImpl;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreCollectionRemoveEventListener;
import org.hibernate.event.spi.PreCollectionUpdateEventListener;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class EnversIntegrator
implements Integrator {
    public static final String AUTO_REGISTER = "hibernate.listeners.envers.autoRegister";

    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        EnversService enversService = (EnversService)serviceRegistry.getService(EnversService.class);
        if (!enversService.isEnabled()) {
            return;
        }
        if (!enversService.isInitialized()) {
            throw new HibernateException("Expecting EnversService to have been initialized prior to call to EnversIntegrator#integrate");
        }
        EventListenerRegistry listenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        listenerRegistry.addDuplicationStrategy((DuplicationStrategy)EnversListenerDuplicationStrategy.INSTANCE);
        if (enversService.getEntitiesConfigurations().hasAuditedEntities()) {
            listenerRegistry.appendListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{new EnversPostDeleteEventListenerImpl(enversService)});
            listenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{new EnversPostInsertEventListenerImpl(enversService)});
            listenerRegistry.appendListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{new EnversPostUpdateEventListenerImpl(enversService)});
            listenerRegistry.appendListeners(EventType.POST_COLLECTION_RECREATE, (Object[])new PostCollectionRecreateEventListener[]{new EnversPostCollectionRecreateEventListenerImpl(enversService)});
            listenerRegistry.appendListeners(EventType.PRE_COLLECTION_REMOVE, (Object[])new PreCollectionRemoveEventListener[]{new EnversPreCollectionRemoveEventListenerImpl(enversService)});
            listenerRegistry.appendListeners(EventType.PRE_COLLECTION_UPDATE, (Object[])new PreCollectionUpdateEventListener[]{new EnversPreCollectionUpdateEventListenerImpl(enversService)});
        }
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }
}

