/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreSlavePolicy;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.BackupRecoveryJournalLoader;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.core.server.management.ManagementService;

public final class SharedStoreBackupActivation
extends Activation {
    private SharedStoreSlavePolicy sharedStoreSlavePolicy;
    private ActiveMQServerImpl activeMQServer;
    private final Object failbackCheckerGuard = new Object();
    private boolean cancelFailBackChecker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedStoreBackupActivation(ActiveMQServerImpl server, SharedStoreSlavePolicy sharedStoreSlavePolicy) {
        this.activeMQServer = server;
        this.sharedStoreSlavePolicy = sharedStoreSlavePolicy;
        Object object = this.failbackCheckerGuard;
        synchronized (object) {
            this.cancelFailBackChecker = false;
        }
    }

    @Override
    public void run() {
        try {
            boolean scalingDown;
            this.activeMQServer.getNodeManager().startBackup();
            boolean bl = scalingDown = this.sharedStoreSlavePolicy.getScaleDownPolicy() != null;
            if (!this.activeMQServer.initialisePart1(scalingDown)) {
                return;
            }
            this.activeMQServer.getBackupManager().start();
            this.activeMQServer.setState(ActiveMQServerImpl.SERVER_STATE.STARTED);
            ActiveMQServerLogger.LOGGER.backupServerStarted(this.activeMQServer.getVersion().getFullVersion(), this.activeMQServer.getNodeManager().getNodeId());
            this.activeMQServer.getNodeManager().awaitLiveNode();
            this.sharedStoreSlavePolicy.getSharedStoreMasterPolicy().setSharedStoreSlavePolicy(this.sharedStoreSlavePolicy);
            this.activeMQServer.setHAPolicy(this.sharedStoreSlavePolicy.getSharedStoreMasterPolicy());
            this.activeMQServer.getBackupManager().activated();
            if (this.activeMQServer.getState() != ActiveMQServerImpl.SERVER_STATE.STARTED) {
                return;
            }
            this.activeMQServer.initialisePart2(scalingDown);
            this.activeMQServer.completeActivation();
            if (scalingDown) {
                ActiveMQServerLogger.LOGGER.backupServerScaledDown();
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SharedStoreBackupActivation.this.activeMQServer.stop();
                            if (SharedStoreBackupActivation.this.sharedStoreSlavePolicy.isRestartBackup()) {
                                SharedStoreBackupActivation.this.activeMQServer.start();
                            }
                        }
                        catch (Exception e) {
                            ActiveMQServerLogger.LOGGER.serverRestartWarning();
                        }
                    }
                });
                t.start();
                return;
            }
            ActiveMQServerLogger.LOGGER.backupServerIsLive();
            this.activeMQServer.getNodeManager().releaseBackup();
            if (this.sharedStoreSlavePolicy.isAllowAutoFailBack()) {
                this.startFailbackChecker();
            }
        }
        catch (InterruptedException e) {
        }
        catch (ClosedChannelException e) {
        }
        catch (Exception e) {
            if (!(e.getCause() instanceof InterruptedException)) {
                ActiveMQServerLogger.LOGGER.initializationError(e);
            }
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.initializationError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        if (!restarting) {
            Object object = this.failbackCheckerGuard;
            synchronized (object) {
                this.cancelFailBackChecker = true;
            }
        }
        NodeManager nodeManagerInUse = this.activeMQServer.getNodeManager();
        if (this.activeMQServer.getHAPolicy().isBackup()) {
            this.activeMQServer.interrupBackupThread(nodeManagerInUse);
            if (nodeManagerInUse != null) {
                nodeManagerInUse.stopBackup();
            }
        } else if (nodeManagerInUse != null) {
            if (this.sharedStoreSlavePolicy.isFailoverOnServerShutdown() || permanently) {
                nodeManagerInUse.crashLiveServer();
            } else {
                nodeManagerInUse.pauseLiveServer();
            }
        }
    }

    @Override
    public JournalLoader createJournalLoader(PostOffice postOffice, PagingManager pagingManager, StorageManager storageManager, QueueFactory queueFactory, NodeManager nodeManager, ManagementService managementService, GroupingHandler groupingHandler, Configuration configuration, ActiveMQServer parentServer) throws ActiveMQException {
        if (this.sharedStoreSlavePolicy.getScaleDownPolicy() != null && this.sharedStoreSlavePolicy.getScaleDownPolicy().isEnabled()) {
            return new BackupRecoveryJournalLoader(postOffice, pagingManager, storageManager, queueFactory, nodeManager, managementService, groupingHandler, configuration, parentServer, ScaleDownPolicy.getScaleDownConnector(this.sharedStoreSlavePolicy.getScaleDownPolicy(), this.activeMQServer), this.activeMQServer.getClusterManager().getClusterController());
        }
        return super.createJournalLoader(postOffice, pagingManager, storageManager, queueFactory, nodeManager, managementService, groupingHandler, configuration, parentServer);
    }

    private void startFailbackChecker() {
        this.activeMQServer.getScheduledPool().scheduleAtFixedRate(new FailbackChecker(), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private class FailbackChecker
    implements Runnable {
        private boolean restarting = false;

        private FailbackChecker() {
        }

        @Override
        public void run() {
            try {
                if (!this.restarting && SharedStoreBackupActivation.this.activeMQServer.getNodeManager().isAwaitingFailback()) {
                    ActiveMQServerLogger.LOGGER.awaitFailBack();
                    this.restarting = true;
                    Thread t = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                ActiveMQServerLogger.LOGGER.debug(SharedStoreBackupActivation.this.activeMQServer + "::Stopping live node in favor of failback");
                                SharedStoreBackupActivation.this.activeMQServer.stop(true, false, true);
                                Thread.sleep(SharedStoreBackupActivation.this.sharedStoreSlavePolicy.getFailbackDelay());
                                Object object = SharedStoreBackupActivation.this.failbackCheckerGuard;
                                synchronized (object) {
                                    if (SharedStoreBackupActivation.this.cancelFailBackChecker || !SharedStoreBackupActivation.this.sharedStoreSlavePolicy.isRestartBackup()) {
                                        return;
                                    }
                                    SharedStoreBackupActivation.this.activeMQServer.setHAPolicy(SharedStoreBackupActivation.this.sharedStoreSlavePolicy);
                                    ActiveMQServerLogger.LOGGER.debug(SharedStoreBackupActivation.this.activeMQServer + "::Starting backup node now after failback");
                                    SharedStoreBackupActivation.this.activeMQServer.start();
                                }
                            }
                            catch (Exception e) {
                                ActiveMQServerLogger.LOGGER.serverRestartWarning();
                            }
                        }
                    });
                    t.start();
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.serverRestartWarning(e);
            }
        }
    }
}

