/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.transport.jgroups.CommandAwareRpcDispatcher;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.remoting.transport.jgroups.MarshallerAdapter;
import org.infinispan.util.TimeService;
import org.jgroups.Channel;
import org.jgroups.blocks.RpcDispatcher;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

public class ChannelTransport
extends JGroupsTransport {
    final ChannelFactory factory;
    private TimeService timeService;

    public ChannelTransport(Channel channel, ChannelFactory factory) {
        super(channel);
        this.factory = factory;
    }

    @Inject
    public void initialize(@ComponentName(value="org.infinispan.marshaller.global") StreamingMarshaller marshaller, @ComponentName(value="org.infinispan.executors.transport") ExecutorService asyncExecutor, CacheManagerNotifier notifier, GlobalComponentRegistry gcr, TimeService timeService, InboundInvocationHandler globalHandler) {
        super.initialize(marshaller, asyncExecutor, notifier, gcr, timeService, globalHandler);
        this.timeService = timeService;
    }

    protected void initRPCDispatcher() {
        this.dispatcher = new CommandAwareRpcDispatcher(this.channel, (JGroupsTransport)this, this.asyncExecutor, this.timeService, this.globalHandler);
        MarshallerAdapter adapter = new MarshallerAdapter(this.marshaller){

            public Object objectFromBuffer(byte[] buffer, int offset, int length) throws Exception {
                return ChannelTransport.this.factory.isUnknownForkResponse(ByteBuffer.wrap(buffer, offset, length)) ? CacheNotFoundResponse.INSTANCE : super.objectFromBuffer(buffer, offset, length);
            }
        };
        this.dispatcher.setRequestMarshaller((RpcDispatcher.Marshaller)adapter);
        this.dispatcher.setResponseMarshaller((RpcDispatcher.Marshaller)adapter);
        this.dispatcher.start();
    }

    protected synchronized void initChannel() {
        this.channel.setDiscardOwnMessages(false);
        this.connectChannel = true;
        this.disconnectChannel = true;
        this.closeChannel = false;
    }
}

