/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.File;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.ServiceLoader;
import org.infinispan.Cache;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.AdvancedCacheConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LockingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreType;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.XAResourceRecoveryBuilder;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.service.CacheBuilder;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.CacheGroupBuilderProvider;
import org.wildfly.clustering.spi.ClusteredCacheGroupBuilderProvider;
import org.wildfly.clustering.spi.LocalCacheGroupBuilderProvider;

public class CacheAddHandler
extends AbstractAddStepHandler {
    private static final ModuleIdentifier QUERY_MODULE = ModuleIdentifier.fromString((String)"org.infinispan.query");
    final CacheMode mode;

    CacheAddHandler(CacheMode mode) {
        super(CacheResourceDefinition.ATTRIBUTES);
        this.mode = mode;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode cacheModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        PathAddress address = context.getCurrentAddress();
        PathAddress containerAddress = address.subAddress(0, address.size() - 1);
        ModelNode containerModel = context.readResourceFromRoot(containerAddress).getModel();
        this.installRuntimeServices(context, operation, containerModel, cacheModel);
    }

    void installRuntimeServices(OperationContext context, ModelNode operation, ModelNode containerModel, ModelNode cacheModel) throws OperationFailedException {
        PathAddress address = Operations.getPathAddress((ModelNode)operation);
        String containerName = address.getElement(address.size() - 2).getValue();
        String cacheName = address.getElement(address.size() - 1).getValue();
        String jndiName = ModelNodes.asString((ModelNode)CacheResourceDefinition.JNDI_NAME.resolveModelAttribute(context, cacheModel));
        ModuleIdentifier module = ModelNodes.asModuleIdentifier((ModelNode)CacheResourceDefinition.MODULE.resolveModelAttribute(context, cacheModel));
        if (module == null && Index.valueOf((String)CacheResourceDefinition.INDEXING.resolveModelAttribute(context, cacheModel).asString()).isEnabled()) {
            module = QUERY_MODULE;
        }
        AdvancedCacheConfigurationBuilder builder = new AdvancedCacheConfigurationBuilder(containerName, cacheName, this.mode, module);
        this.processModelNode(context, containerName, containerModel, cacheModel, builder);
        ServiceTarget target = context.getServiceTarget();
        builder.build(target).install();
        new CacheBuilder(containerName, cacheName).build(target).install();
        BinderServiceBuilder bindingBuilder = new BinderServiceBuilder(InfinispanBindingFactory.createCacheBinding(containerName, cacheName), CacheServiceName.CACHE.getServiceName(containerName, cacheName), Cache.class);
        if (jndiName != null) {
            bindingBuilder.alias(ContextNames.bindInfoFor((String)JndiNameFactory.parse((String)jndiName).getAbsoluteName()));
        }
        bindingBuilder.build(target).install();
        new XAResourceRecoveryBuilder(containerName, cacheName).build(target).install();
        Class providerClass = this.mode.isClustered() ? ClusteredCacheGroupBuilderProvider.class : LocalCacheGroupBuilderProvider.class;
        for (CacheGroupBuilderProvider cacheGroupBuilderProvider : ServiceLoader.load(providerClass, providerClass.getClassLoader())) {
            if (InfinispanLogger.ROOT_LOGGER.isDebugEnabled()) {
                InfinispanLogger.ROOT_LOGGER.debugf("Installing %s for cache %s of container %s", cacheGroupBuilderProvider.getClass().getSimpleName(), cacheName, containerName);
            }
            for (Builder groupBuilder : cacheGroupBuilderProvider.getBuilders(containerName, cacheName)) {
                groupBuilder.build(target).install();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode containerModel, ModelNode cacheModel) {
        void var10_12;
        PathAddress address = Operations.getPathAddress((ModelNode)operation);
        String containerName = address.getElement(address.size() - 2).getValue();
        String cacheName = address.getElement(address.size() - 1).getValue();
        context.removeService(InfinispanBindingFactory.createCacheBinding(containerName, cacheName).getBinderServiceName());
        CacheServiceName[] cacheServiceNameArray = CacheServiceName.values();
        int n = cacheServiceNameArray.length;
        boolean bl = false;
        while (var10_12 < n) {
            CacheServiceName factory = cacheServiceNameArray[var10_12];
            context.removeService(factory.getServiceName(containerName, cacheName));
            ++var10_12;
        }
        Class installerClass = this.mode.isClustered() ? ClusteredCacheGroupBuilderProvider.class : LocalCacheGroupBuilderProvider.class;
        for (CacheGroupBuilderProvider cacheGroupBuilderProvider : ServiceLoader.load(installerClass, installerClass.getClassLoader())) {
            for (Builder builder : cacheGroupBuilderProvider.getBuilders(containerName, cacheName)) {
                context.removeService(builder.getServiceName());
            }
        }
        InfinispanLogger.ROOT_LOGGER.debugf("cache %s removed for container %s", cacheName, containerName);
    }

    void processModelNode(OperationContext context, String containerName, ModelNode containerModel, ModelNode cache, AdvancedCacheConfigurationBuilder configBuilder) throws OperationFailedException {
        ModelNode store;
        StoreType type;
        ModelNode expiration;
        ModelNode eviction;
        ModelNode transaction;
        ConfigurationBuilder builder = configBuilder.getConfigurationBuilder();
        if (cache.hasDefined(CacheResourceDefinition.STATISTICS_ENABLED.getName())) {
            builder.jmxStatistics().enabled(CacheResourceDefinition.STATISTICS_ENABLED.resolveModelAttribute(context, cache).asBoolean());
        } else {
            builder.jmxStatistics().enabled(CacheContainerResourceDefinition.STATISTICS_ENABLED.resolveModelAttribute(context, containerModel).asBoolean());
        }
        Index indexing = Index.valueOf((String)CacheResourceDefinition.INDEXING.resolveModelAttribute(context, cache).asString());
        builder.clustering().cacheMode(this.mode);
        ModelNode indexingPropertiesModel = CacheResourceDefinition.INDEXING_PROPERTIES.resolveModelAttribute(context, cache);
        Properties indexingProperties = new Properties();
        if (indexing.isEnabled() && indexingPropertiesModel.isDefined()) {
            for (Property p : indexingPropertiesModel.asPropertyList()) {
                String value = p.getValue().asString();
                indexingProperties.put(p.getName(), value);
            }
        }
        builder.indexing().index(indexing).withProperties(indexingProperties);
        IsolationLevel isolationLevel = IsolationLevel.valueOf((String)LockingResourceDefinition.ISOLATION.getDefaultValue().asString());
        if (cache.hasDefined(LockingResourceDefinition.PATH.getKey()) && cache.get(LockingResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
            ModelNode locking = cache.get(LockingResourceDefinition.PATH.getKeyValuePair());
            isolationLevel = IsolationLevel.valueOf((String)LockingResourceDefinition.ISOLATION.resolveModelAttribute(context, locking).asString());
            boolean striping = LockingResourceDefinition.STRIPING.resolveModelAttribute(context, locking).asBoolean();
            long acquireTimeout = LockingResourceDefinition.ACQUIRE_TIMEOUT.resolveModelAttribute(context, locking).asLong();
            int concurrencyLevel = LockingResourceDefinition.CONCURRENCY_LEVEL.resolveModelAttribute(context, locking).asInt();
            builder.locking().isolationLevel(isolationLevel).useLockStriping(striping).lockAcquisitionTimeout(acquireTimeout).concurrencyLevel(concurrencyLevel);
        }
        if (cache.hasDefined(TransactionResourceDefinition.PATH.getKey()) && (transaction = cache.get(TransactionResourceDefinition.PATH.getKeyValuePair())).isDefined()) {
            long stopTimeout = TransactionResourceDefinition.STOP_TIMEOUT.resolveModelAttribute(context, transaction).asLong();
            TransactionMode txMode = TransactionMode.valueOf(TransactionResourceDefinition.MODE.resolveModelAttribute(context, transaction).asString());
            LockingMode lockingMode = LockingMode.valueOf((String)TransactionResourceDefinition.LOCKING.resolveModelAttribute(context, transaction).asString());
            configBuilder.setTransactionMode(txMode);
            builder.transaction().cacheStopTimeout(stopTimeout).transactionMode(txMode == TransactionMode.NONE ? org.infinispan.transaction.TransactionMode.NON_TRANSACTIONAL : org.infinispan.transaction.TransactionMode.TRANSACTIONAL).lockingMode(lockingMode).useSynchronization(txMode == TransactionMode.NON_XA).recovery().enabled(txMode == TransactionMode.FULL_XA).invocationBatching().disable();
            if (lockingMode == LockingMode.OPTIMISTIC && isolationLevel == IsolationLevel.REPEATABLE_READ && this.mode.isSynchronous() && !this.mode.isInvalidation()) {
                builder.locking().writeSkewCheck(true);
                builder.versioning().enable().scheme(VersioningScheme.SIMPLE);
            }
        }
        if (cache.hasDefined(EvictionResourceDefinition.PATH.getKey()) && (eviction = cache.get(EvictionResourceDefinition.PATH.getKeyValuePair())).isDefined()) {
            EvictionStrategy strategy = EvictionStrategy.valueOf((String)EvictionResourceDefinition.STRATEGY.resolveModelAttribute(context, eviction).asString());
            builder.eviction().strategy(strategy);
            if (strategy.isEnabled()) {
                long maxEntries = EvictionResourceDefinition.MAX_ENTRIES.resolveModelAttribute(context, eviction).asLong();
                builder.eviction().maxEntries(maxEntries);
            }
        }
        if (cache.hasDefined(ExpirationResourceDefinition.PATH.getKey()) && (expiration = cache.get(ExpirationResourceDefinition.PATH.getKeyValuePair())).isDefined()) {
            long maxIdle = ExpirationResourceDefinition.MAX_IDLE.resolveModelAttribute(context, expiration).asLong();
            long lifespan = ExpirationResourceDefinition.LIFESPAN.resolveModelAttribute(context, expiration).asLong();
            long interval = ExpirationResourceDefinition.INTERVAL.resolveModelAttribute(context, expiration).asLong();
            builder.expiration().maxIdle(maxIdle).lifespan(lifespan).wakeUpInterval(interval);
            if (maxIdle > 0L || lifespan > 0L) {
                builder.expiration().enableReaper();
            } else {
                builder.expiration().disableReaper();
            }
        }
        if ((type = CacheAddHandler.findStoreType(cache)) != null && (store = cache.get(type.pathElement().getKeyValuePair())).isDefined()) {
            ModelNode writeBehind;
            PersistenceConfigurationBuilder persistenceBuilder = builder.persistence().passivation(StoreResourceDefinition.PASSIVATION.resolveModelAttribute(context, store).asBoolean());
            StoreConfigurationBuilder storeBuilder = (StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)CacheAddHandler.buildCacheStore(context, persistenceBuilder, containerName, type, store, configBuilder).fetchPersistentState(StoreResourceDefinition.FETCH_STATE.resolveModelAttribute(context, store).asBoolean())).preload(StoreResourceDefinition.PRELOAD.resolveModelAttribute(context, store).asBoolean())).shared(StoreResourceDefinition.SHARED.resolveModelAttribute(context, store).asBoolean())).purgeOnStartup(StoreResourceDefinition.PURGE.resolveModelAttribute(context, store).asBoolean());
            storeBuilder.singleton().enabled(StoreResourceDefinition.SINGLETON.resolveModelAttribute(context, store).asBoolean());
            if (store.hasDefined(StoreWriteBehindResourceDefinition.PATH.getKey()) && (writeBehind = store.get(StoreWriteBehindResourceDefinition.PATH.getKeyValuePair())).isDefined()) {
                storeBuilder.async().enable().flushLockTimeout(StoreWriteBehindResourceDefinition.FLUSH_LOCK_TIMEOUT.resolveModelAttribute(context, writeBehind).asLong()).modificationQueueSize(StoreWriteBehindResourceDefinition.MODIFICATION_QUEUE_SIZE.resolveModelAttribute(context, writeBehind).asInt()).shutdownTimeout(StoreWriteBehindResourceDefinition.SHUTDOWN_TIMEOUT.resolveModelAttribute(context, writeBehind).asLong()).threadPoolSize(StoreWriteBehindResourceDefinition.THREAD_POOL_SIZE.resolveModelAttribute(context, writeBehind).asInt());
            }
            TypedProperties properties = new TypedProperties();
            if (store.hasDefined(StoreResourceDefinition.PROPERTIES.getName())) {
                for (Property property : StoreResourceDefinition.PROPERTIES.resolveModelAttribute(context, store).asPropertyList()) {
                    properties.setProperty(property.getName(), property.getValue().asString());
                }
            }
            storeBuilder.withProperties((Properties)properties);
        }
    }

    private static StoreType findStoreType(ModelNode cache) {
        for (StoreType store : StoreType.values()) {
            if (!cache.hasDefined(store.pathElement().getKey())) continue;
            return store;
        }
        return null;
    }

    private static StoreConfigurationBuilder<?, ?> buildCacheStore(OperationContext context, PersistenceConfigurationBuilder persistenceBuilder, String containerName, StoreType storeType, ModelNode store, AdvancedCacheConfigurationBuilder configBuilder) throws OperationFailedException {
        switch (storeType) {
            case FILE: {
                final SingleFileStoreConfigurationBuilder builder = persistenceBuilder.addSingleFileStore();
                final String path = ModelNodes.asString((ModelNode)FileStoreResourceDefinition.RELATIVE_PATH.resolveModelAttribute(context, store), (String)("infinispan" + File.separatorChar + containerName));
                final String relativeTo = FileStoreResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, store).asString();
                Injector<PathManager> injector = new Injector<PathManager>(){
                    private volatile PathManager.Callback.Handle callbackHandle;

                    public void inject(PathManager value) {
                        this.callbackHandle = value.registerCallback(relativeTo, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
                        builder.location(value.resolveRelativePathEntry(path, relativeTo));
                    }

                    public void uninject() {
                        if (this.callbackHandle != null) {
                            this.callbackHandle.remove();
                        }
                    }
                };
                configBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, injector);
                return builder;
            }
            case STRING_KEYED_JDBC: 
            case BINARY_KEYED_JDBC: 
            case MIXED_KEYED_JDBC: {
                DatabaseType dialect = (DatabaseType)ModelNodes.asEnum((ModelNode)JDBCStoreResourceDefinition.DIALECT.resolveModelAttribute(context, store), DatabaseType.class);
                AbstractJdbcStoreConfigurationBuilder builder = CacheAddHandler.buildJdbcStore(persistenceBuilder, context, store).dialect(dialect);
                String datasource = JDBCStoreResourceDefinition.DATA_SOURCE.resolveModelAttribute(context, store).asString();
                configBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"data-source", datasource}));
                builder.dataSource().jndiUrl(datasource);
                return builder;
            }
            case REMOTE: {
                final RemoteStoreConfigurationBuilder builder = (RemoteStoreConfigurationBuilder)persistenceBuilder.addStore(RemoteStoreConfigurationBuilder.class);
                for (ModelNode server : store.require("remote-servers").asList()) {
                    String outboundSocketBinding = server.get("outbound-socket-binding").asString();
                    Injector<OutboundSocketBinding> injector = new Injector<OutboundSocketBinding>(){

                        public void inject(OutboundSocketBinding value) {
                            try {
                                builder.addServer().host(value.getResolvedDestinationAddress().getHostAddress()).port(value.getDestinationPort());
                            }
                            catch (UnknownHostException e) {
                                throw InfinispanLogger.ROOT_LOGGER.failedToInjectSocketBinding(e, value);
                            }
                        }

                        public void uninject() {
                        }
                    };
                    configBuilder.addDependency(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{outboundSocketBinding}), OutboundSocketBinding.class, injector);
                }
                builder.remoteCacheName(RemoteStoreResourceDefinition.CACHE.resolveModelAttribute(context, store).asString());
                builder.socketTimeout(RemoteStoreResourceDefinition.SOCKET_TIMEOUT.resolveModelAttribute(context, store).asLong());
                builder.tcpNoDelay(RemoteStoreResourceDefinition.TCP_NO_DELAY.resolveModelAttribute(context, store).asBoolean());
                return builder;
            }
            case CUSTOM: {
                String className = store.require("class").asString();
                try {
                    return persistenceBuilder.addStore(StoreConfigurationBuilder.class.getClassLoader().loadClass(className).asSubclass(StoreConfigurationBuilder.class));
                }
                catch (Exception e) {
                    throw InfinispanLogger.ROOT_LOGGER.invalidCacheStore(e, className);
                }
            }
        }
        throw new IllegalStateException();
    }

    private static AbstractJdbcStoreConfigurationBuilder<?, ?> buildJdbcStore(PersistenceConfigurationBuilder persistenceBuilder, OperationContext context, ModelNode store) throws OperationFailedException {
        boolean useStringKeyedTable = store.hasDefined(JDBCStoreResourceDefinition.STRING_KEYED_TABLE.getName());
        boolean useBinaryKeyedTable = store.hasDefined(JDBCStoreResourceDefinition.BINARY_KEYED_TABLE.getName());
        if (useStringKeyedTable && !useBinaryKeyedTable) {
            JdbcStringBasedStoreConfigurationBuilder builder = (JdbcStringBasedStoreConfigurationBuilder)persistenceBuilder.addStore(JdbcStringBasedStoreConfigurationBuilder.class);
            CacheAddHandler.buildStringKeyedTable(builder.table(), context, store.get(JDBCStoreResourceDefinition.STRING_KEYED_TABLE.getName()));
            return builder;
        }
        if (useBinaryKeyedTable && !useStringKeyedTable) {
            JdbcBinaryStoreConfigurationBuilder builder = (JdbcBinaryStoreConfigurationBuilder)persistenceBuilder.addStore(JdbcBinaryStoreConfigurationBuilder.class);
            CacheAddHandler.buildBinaryKeyedTable(builder.table(), context, store.get(JDBCStoreResourceDefinition.BINARY_KEYED_TABLE.getName()));
            return builder;
        }
        JdbcMixedStoreConfigurationBuilder builder = (JdbcMixedStoreConfigurationBuilder)persistenceBuilder.addStore(JdbcMixedStoreConfigurationBuilder.class);
        CacheAddHandler.buildStringKeyedTable(builder.stringTable(), context, store.get(JDBCStoreResourceDefinition.STRING_KEYED_TABLE.getName()));
        CacheAddHandler.buildBinaryKeyedTable(builder.binaryTable(), context, store.get(JDBCStoreResourceDefinition.BINARY_KEYED_TABLE.getName()));
        return builder;
    }

    private static void buildBinaryKeyedTable(TableManipulationConfigurationBuilder<?, ?> builder, OperationContext context, ModelNode table) throws OperationFailedException {
        CacheAddHandler.buildTable(builder, context, table, "ispn_bucket");
    }

    private static void buildStringKeyedTable(TableManipulationConfigurationBuilder<?, ?> builder, OperationContext context, ModelNode table) throws OperationFailedException {
        CacheAddHandler.buildTable(builder, context, table, "ispn_entry");
    }

    private static void buildTable(TableManipulationConfigurationBuilder<?, ?> builder, OperationContext context, ModelNode table, String defaultTableNamePrefix) throws OperationFailedException {
        builder.batchSize(JDBCStoreResourceDefinition.BATCH_SIZE.resolveModelAttribute(context, table).asInt()).fetchSize(JDBCStoreResourceDefinition.FETCH_SIZE.resolveModelAttribute(context, table).asInt()).tableNamePrefix(ModelNodes.asString((ModelNode)JDBCStoreResourceDefinition.PREFIX.resolveModelAttribute(context, table), (String)defaultTableNamePrefix)).idColumnName(CacheAddHandler.getColumnProperty(context, table, (AttributeDefinition)JDBCStoreResourceDefinition.ID_COLUMN, (AttributeDefinition)JDBCStoreResourceDefinition.COLUMN_NAME, "id")).idColumnType(CacheAddHandler.getColumnProperty(context, table, (AttributeDefinition)JDBCStoreResourceDefinition.ID_COLUMN, (AttributeDefinition)JDBCStoreResourceDefinition.COLUMN_TYPE, "VARCHAR")).dataColumnName(CacheAddHandler.getColumnProperty(context, table, (AttributeDefinition)JDBCStoreResourceDefinition.DATA_COLUMN, (AttributeDefinition)JDBCStoreResourceDefinition.COLUMN_NAME, "datum")).dataColumnType(CacheAddHandler.getColumnProperty(context, table, (AttributeDefinition)JDBCStoreResourceDefinition.DATA_COLUMN, (AttributeDefinition)JDBCStoreResourceDefinition.COLUMN_TYPE, "BINARY")).timestampColumnName(CacheAddHandler.getColumnProperty(context, table, (AttributeDefinition)JDBCStoreResourceDefinition.TIMESTAMP_COLUMN, (AttributeDefinition)JDBCStoreResourceDefinition.COLUMN_NAME, "version")).timestampColumnType(CacheAddHandler.getColumnProperty(context, table, (AttributeDefinition)JDBCStoreResourceDefinition.TIMESTAMP_COLUMN, (AttributeDefinition)JDBCStoreResourceDefinition.COLUMN_TYPE, "BIGINT"));
    }

    private static String getColumnProperty(OperationContext context, ModelNode table, AttributeDefinition columnResourceDefinition, AttributeDefinition columnAttribute, String defaultValue) throws OperationFailedException {
        if (!table.isDefined() || !table.hasDefined(columnResourceDefinition.getName())) {
            return defaultValue;
        }
        return ModelNodes.asString((ModelNode)columnAttribute.resolveModelAttribute(context, table.get(columnResourceDefinition.getName())), (String)defaultValue);
    }

    protected class Dependency<I> {
        private final ServiceName name;
        private final Class<I> type;
        private final Injector<I> target;

        Dependency(ServiceName name) {
            this(name, null, null);
        }

        Dependency(ServiceName name, Class<I> type, Injector<I> target) {
            this.name = name;
            this.type = type;
            this.target = target;
        }

        ServiceName getName() {
            return this.name;
        }

        public Class<I> getType() {
            return this.type;
        }

        public Injector<I> getInjector() {
            return this.target;
        }
    }
}

