/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.SequenceFault;

public class RMDeliveryInterceptor
extends AbstractRMInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(RMDeliveryInterceptor.class);

    public RMDeliveryInterceptor() {
        super("post-invoke");
        this.addBefore(OutgoingChainInterceptor.class.getName());
    }

    @Override
    public void handle(Message message) throws SequenceFault, RMException {
        AddressingProperties maps = ContextUtils.retrieveMAPs((Message)message, (boolean)false, (boolean)false, (boolean)false);
        if (maps == null && this.isRMPolicyEnabled(message)) {
            return;
        }
        LOG.entering(((Object)((Object)this)).getClass().getName(), "handleMessage");
        Destination dest = this.getManager().getDestination(message);
        boolean robust = MessageUtils.isTrue((Object)message.getContextualProperty("org.apache.cxf.oneway.robust"));
        if (robust) {
            message.remove((Object)"org.apache.cxf.oneway.robust.delivering");
            dest.acknowledge(message);
        }
        dest.processingComplete(message);
    }
}

