/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FixedSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class UUIDType
extends AbstractPrimitiveType<UUID> {
    private UUIDEncoding _uuidEncoding;

    UUIDType(EncoderImpl encoder, DecoderImpl decoder) {
        this._uuidEncoding = new UUIDEncoding(encoder, decoder);
        encoder.register(UUID.class, this);
        decoder.register(this);
    }

    @Override
    public Class<UUID> getTypeClass() {
        return UUID.class;
    }

    public UUIDEncoding getEncoding(UUID val) {
        return this._uuidEncoding;
    }

    public UUIDEncoding getCanonicalEncoding() {
        return this._uuidEncoding;
    }

    @Override
    public Collection<UUIDEncoding> getAllEncodings() {
        return Collections.singleton(this._uuidEncoding);
    }

    private class UUIDEncoding
    extends FixedSizePrimitiveTypeEncoding<UUID> {
        public UUIDEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected int getFixedSize() {
            return 16;
        }

        @Override
        public byte getEncodingCode() {
            return -104;
        }

        public UUIDType getType() {
            return UUIDType.this;
        }

        @Override
        public void writeValue(UUID val) {
            this.getEncoder().writeRaw(val.getMostSignificantBits());
            this.getEncoder().writeRaw(val.getLeastSignificantBits());
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<UUID> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public UUID readValue() {
            long msb = this.getDecoder().readRawLong();
            long lsb = this.getDecoder().readRawLong();
            return new UUID(msb, lsb);
        }
    }
}

