/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.io.Serializable;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryTopic;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.jms.referenceable.DestinationObjectFactory;
import org.apache.activemq.artemis.jms.referenceable.SerializableObjectRefAddr;

public class ActiveMQDestination
implements Destination,
Serializable,
Referenceable {
    private static final long serialVersionUID = 5027962425462382883L;
    public static final String JMS_QUEUE_ADDRESS_PREFIX = "jms.queue.";
    public static final String JMS_TEMP_QUEUE_ADDRESS_PREFIX = "jms.tempqueue.";
    public static final String JMS_TOPIC_ADDRESS_PREFIX = "jms.topic.";
    public static final String JMS_TEMP_TOPIC_ADDRESS_PREFIX = "jms.temptopic.";
    private static final char SEPARATOR = '.';
    protected final String name;
    private final String address;
    private final SimpleString simpleAddress;
    private final boolean temporary;
    private final boolean queue;
    private final transient ActiveMQSession session;

    private static String escape(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("\\", "\\\\").replace(".", "\\.");
    }

    public static Destination fromAddress(String address) {
        if (address.startsWith(JMS_QUEUE_ADDRESS_PREFIX)) {
            String name = address.substring(JMS_QUEUE_ADDRESS_PREFIX.length());
            return ActiveMQDestination.createQueue(name);
        }
        if (address.startsWith(JMS_TOPIC_ADDRESS_PREFIX)) {
            String name = address.substring(JMS_TOPIC_ADDRESS_PREFIX.length());
            return ActiveMQDestination.createTopic(name);
        }
        if (address.startsWith(JMS_TEMP_QUEUE_ADDRESS_PREFIX)) {
            String name = address.substring(JMS_TEMP_QUEUE_ADDRESS_PREFIX.length());
            return new ActiveMQTemporaryQueue(address, name, null);
        }
        if (address.startsWith(JMS_TEMP_TOPIC_ADDRESS_PREFIX)) {
            String name = address.substring(JMS_TEMP_TOPIC_ADDRESS_PREFIX.length());
            return new ActiveMQTemporaryTopic(address, name, null);
        }
        throw new JMSRuntimeException("Invalid address " + address);
    }

    public static String createQueueNameForDurableSubscription(boolean isDurable, String clientID, String subscriptionName) {
        if (clientID != null) {
            if (isDurable) {
                return ActiveMQDestination.escape(clientID) + '.' + ActiveMQDestination.escape(subscriptionName);
            }
            return "nonDurable." + ActiveMQDestination.escape(clientID) + '.' + ActiveMQDestination.escape(subscriptionName);
        }
        if (isDurable) {
            return ActiveMQDestination.escape(subscriptionName);
        }
        return "nonDurable." + ActiveMQDestination.escape(subscriptionName);
    }

    public static String createQueueNameForSharedSubscription(boolean isDurable, String clientID, String subscriptionName) {
        if (clientID != null) {
            return (isDurable ? "Durable" : "nonDurable") + '.' + ActiveMQDestination.escape(clientID) + '.' + ActiveMQDestination.escape(subscriptionName);
        }
        return (isDurable ? "Durable" : "nonDurable") + '.' + ActiveMQDestination.escape(subscriptionName);
    }

    public static Pair<String, String> decomposeQueueNameForDurableSubscription(String queueName) {
        StringBuffer[] parts = new StringBuffer[2];
        int currentPart = 0;
        parts[0] = new StringBuffer();
        parts[1] = new StringBuffer();
        int pos = 0;
        while (pos < queueName.length()) {
            char ch = queueName.charAt(pos);
            ++pos;
            if (ch == '.') {
                if (++currentPart < parts.length) continue;
                throw new JMSRuntimeException("Invalid message queue name: " + queueName);
            }
            if (ch == '\\') {
                if (pos >= queueName.length()) {
                    throw new JMSRuntimeException("Invalid message queue name: " + queueName);
                }
                ch = queueName.charAt(pos);
                ++pos;
            }
            parts[currentPart].append(ch);
        }
        if (currentPart != 1) {
            throw new JMSRuntimeException("Invalid message queue name: " + queueName);
        }
        Pair pair = new Pair((Object)parts[0].toString(), (Object)parts[1].toString());
        return pair;
    }

    public static SimpleString createQueueAddressFromName(String name) {
        return new SimpleString(JMS_QUEUE_ADDRESS_PREFIX + name);
    }

    public static SimpleString createTopicAddressFromName(String name) {
        return new SimpleString(JMS_TOPIC_ADDRESS_PREFIX + name);
    }

    public static ActiveMQQueue createQueue(String name) {
        return new ActiveMQQueue(name);
    }

    public static ActiveMQTopic createTopic(String name) {
        return new ActiveMQTopic(name);
    }

    public static ActiveMQTemporaryQueue createTemporaryQueue(String name, ActiveMQSession session) {
        return new ActiveMQTemporaryQueue(JMS_TEMP_QUEUE_ADDRESS_PREFIX.concat(name), name, session);
    }

    public static ActiveMQTemporaryQueue createTemporaryQueue(String name) {
        return ActiveMQDestination.createTemporaryQueue(name, null);
    }

    public static ActiveMQTemporaryQueue createTemporaryQueue(ActiveMQSession session) {
        String name = UUID.randomUUID().toString();
        return ActiveMQDestination.createTemporaryQueue(name, session);
    }

    public static ActiveMQTemporaryTopic createTemporaryTopic(ActiveMQSession session) {
        String name = UUID.randomUUID().toString();
        return ActiveMQDestination.createTemporaryTopic(name, session);
    }

    public static ActiveMQTemporaryTopic createTemporaryTopic(String name, ActiveMQSession session) {
        return new ActiveMQTemporaryTopic(JMS_TEMP_TOPIC_ADDRESS_PREFIX.concat(name), name, session);
    }

    public static ActiveMQTemporaryTopic createTemporaryTopic(String name) {
        return ActiveMQDestination.createTemporaryTopic(name, null);
    }

    protected ActiveMQDestination(String address, String name, boolean temporary, boolean queue, ActiveMQSession session) {
        this.address = address;
        this.name = name;
        this.simpleAddress = new SimpleString(address);
        this.temporary = temporary;
        this.queue = queue;
        this.session = session;
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(this.getClass().getCanonicalName(), new SerializableObjectRefAddr("ActiveMQ-DEST", this), DestinationObjectFactory.class.getCanonicalName(), null);
    }

    public void delete() throws JMSException {
        if (this.session != null) {
            if (this.session.getCoreSession().isClosed()) {
                return;
            }
            if (this.queue) {
                this.session.deleteTemporaryQueue(this);
            } else {
                this.session.deleteTemporaryTopic(this);
            }
        }
    }

    public boolean isQueue() {
        return this.queue;
    }

    public String getAddress() {
        return this.address;
    }

    public SimpleString getSimpleAddress() {
        return this.simpleAddress;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActiveMQDestination)) {
            return false;
        }
        ActiveMQDestination that = (ActiveMQDestination)o;
        return this.address.equals(that.address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }
}

