/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.naturalid;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.TransactionalAccessDelegate;
import org.hibernate.cache.infinispan.naturalid.NaturalIdRegionImpl;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;

class TransactionalAccess
implements NaturalIdRegionAccessStrategy {
    private final NaturalIdRegionImpl region;
    private final TransactionalAccessDelegate delegate;

    TransactionalAccess(NaturalIdRegionImpl region) {
        this.region = region;
        this.delegate = new TransactionalAccessDelegate(region, region.getPutFromLoadValidator());
    }

    public boolean insert(Object key, Object value) throws CacheException {
        return this.delegate.insert(key, value, null);
    }

    public boolean update(Object key, Object value) throws CacheException {
        return this.delegate.update(key, value, null, null);
    }

    public NaturalIdRegion getRegion() {
        return this.region;
    }

    public void evict(Object key) throws CacheException {
        this.delegate.evict(key);
    }

    public void evictAll() throws CacheException {
        this.delegate.evictAll();
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        return this.delegate.get(key, txTimestamp);
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) throws CacheException {
        return this.delegate.putFromLoad(key, value, txTimestamp, version);
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        return this.delegate.putFromLoad(key, value, txTimestamp, version, minimalPutOverride);
    }

    public void remove(Object key) throws CacheException {
        this.delegate.remove(key);
    }

    public void removeAll() throws CacheException {
        this.delegate.removeAll();
    }

    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return null;
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockItem(Object key, SoftLock lock) throws CacheException {
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
    }

    public boolean afterInsert(Object key, Object value) throws CacheException {
        return false;
    }

    public boolean afterUpdate(Object key, Object value, SoftLock lock) throws CacheException {
        return false;
    }

    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SessionImplementor session) {
        return this.region.getCacheKeysFactory().createNaturalIdKey(naturalIdValues, persister, session);
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return this.region.getCacheKeysFactory().getNaturalIdValues(cacheKey);
    }
}

