/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal;

import javax.transaction.Synchronization;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.jboss.logging.Logger;

public class TransactionImpl
implements Transaction {
    private static final Logger LOG = CoreLogging.logger(TransactionImpl.class);
    private final TransactionCoordinator transactionCoordinator;
    private final TransactionCoordinator.TransactionDriver transactionDriverControl;
    private boolean valid = true;

    public TransactionImpl(TransactionCoordinator transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
        this.transactionDriverControl = transactionCoordinator.getTransactionDriverControl();
    }

    @Override
    public void begin() {
        TransactionStatus status = this.transactionDriverControl.getStatus();
        if (!this.valid) {
            throw new TransactionException("Transaction instance is no longer valid");
        }
        if (status == TransactionStatus.ACTIVE) {
            return;
        }
        LOG.debug((Object)"begin");
        this.transactionDriverControl.begin();
    }

    @Override
    public void commit() {
        TransactionStatus status = this.transactionDriverControl.getStatus();
        if (status != TransactionStatus.ACTIVE) {
            throw new TransactionException("Transaction not successfully started");
        }
        LOG.debug((Object)"committing");
        try {
            this.transactionDriverControl.commit();
        }
        finally {
            this.invalidate();
        }
    }

    @Override
    public void rollback() {
        TransactionStatus status = this.transactionDriverControl.getStatus();
        if (status != TransactionStatus.ACTIVE && status != TransactionStatus.FAILED_COMMIT) {
            throw new TransactionException("Transaction not successfully started");
        }
        LOG.debug((Object)"rolling back");
        if (status != TransactionStatus.FAILED_COMMIT || this.allowFailedCommitToPhysicallyRollback()) {
            try {
                this.transactionDriverControl.rollback();
            }
            finally {
                this.invalidate();
            }
        }
    }

    @Override
    public TransactionStatus getStatus() {
        return this.transactionDriverControl.getStatus();
    }

    @Override
    public void registerSynchronization(Synchronization synchronization) throws HibernateException {
        this.transactionCoordinator.getLocalSynchronizations().registerSynchronization(synchronization);
    }

    @Override
    public void setTimeout(int seconds) {
        this.transactionCoordinator.setTimeOut(seconds);
    }

    @Override
    public int getTimeout() {
        return this.transactionCoordinator.getTimeOut();
    }

    @Override
    public void markRollbackOnly() {
        this.transactionDriverControl.markRollbackOnly();
    }

    public void invalidate() {
        this.valid = false;
    }

    protected boolean allowFailedCommitToPhysicallyRollback() {
        return false;
    }
}

