/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.writers;

import java.io.OutputStream;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLAssertionWriter;
import org.picketlink.identity.federation.core.wstrust.wrappers.Lifetime;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponse;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponseCollection;
import org.picketlink.identity.federation.core.wstrust.writers.WSPolicyWriter;
import org.picketlink.identity.federation.core.wstrust.writers.WSSecurityWriter;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.ws.trust.BinarySecretType;
import org.picketlink.identity.federation.ws.trust.ComputedKeyType;
import org.picketlink.identity.federation.ws.trust.EntropyType;
import org.picketlink.identity.federation.ws.trust.RenewingType;
import org.picketlink.identity.federation.ws.trust.RequestedProofTokenType;
import org.picketlink.identity.federation.ws.trust.RequestedReferenceType;
import org.picketlink.identity.federation.ws.trust.StatusType;
import org.w3c.dom.Element;

public class WSTrustResponseWriter {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final XMLStreamWriter writer;

    public WSTrustResponseWriter(OutputStream stream) throws ProcessingException {
        this.writer = StaxUtil.getXMLStreamWriter((OutputStream)stream);
    }

    public WSTrustResponseWriter(Result result) throws ProcessingException {
        this.writer = StaxUtil.getXMLStreamWriter((Result)result);
    }

    public WSTrustResponseWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public void write(RequestSecurityTokenResponseCollection collection) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"RequestSecurityTokenResponseCollection", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"wst", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        List<RequestSecurityTokenResponse> responses = collection.getRequestSecurityTokenResponses();
        if (responses == null) {
            throw new ProcessingException("PL00092: Null Value:WS-Trust response message doesn't contain any response");
        }
        for (RequestSecurityTokenResponse response : responses) {
            this.write(response);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    private void write(RequestSecurityTokenResponse response) throws ProcessingException {
        BinarySecretType binarySecret;
        RequestedReferenceType ref;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"RequestSecurityTokenResponse", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        String context = response.getContext();
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"Context", (String)context);
        if (response.getTokenType() != null) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"TokenType", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)response.getTokenType().toASCIIString());
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if (response.getLifetime() != null) {
            Lifetime lifetime = response.getLifetime();
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"Lifetime", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            new WSSecurityWriter(this.writer).writeLifetime(lifetime.getCreated(), lifetime.getExpires());
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if (response.getAppliesTo() != null) {
            WSPolicyWriter policyWriter = new WSPolicyWriter(this.writer);
            policyWriter.write(response.getAppliesTo());
        }
        if (response.getKeySize() != 0L) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"KeySize", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)Long.toString(response.getKeySize()));
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if (response.getKeyType() != null) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"KeyType", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)response.getKeyType().toString());
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if (response.getRequestedSecurityToken() != null) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"RequestedSecurityToken", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            List<Object> theList = response.getRequestedSecurityToken().getAny();
            for (Object securityToken : theList) {
                if (securityToken instanceof AssertionType) {
                    AssertionType assertion = (AssertionType)securityToken;
                    SAMLAssertionWriter samlAssertionWriter = new SAMLAssertionWriter(this.writer);
                    samlAssertionWriter.write(assertion);
                    continue;
                }
                if (securityToken instanceof Element) {
                    StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)((Element)securityToken));
                    continue;
                }
                throw logger.writerUnknownTypeError(securityToken.getClass().getName());
            }
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if (response.getRequestedAttachedReference() != null) {
            ref = response.getRequestedAttachedReference();
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"RequestedAttachedReference", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            new WSSecurityWriter(this.writer).writeSecurityTokenReference(ref.getSecurityTokenReference());
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if (response.getRequestedUnattachedReference() != null) {
            ref = response.getRequestedUnattachedReference();
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"RequestedUnattachedReference", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            new WSSecurityWriter(this.writer).writeSecurityTokenReference(ref.getSecurityTokenReference());
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if (response.getRequestedProofToken() != null) {
            RequestedProofTokenType requestedProof = response.getRequestedProofToken();
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"RequestedProofToken", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            List<Object> theList = requestedProof.getAny();
            for (Object content : theList) {
                if (content instanceof BinarySecretType) {
                    binarySecret = (BinarySecretType)content;
                    StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"BinarySecret", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
                    StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"Type", (String)binarySecret.getType());
                    StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)new String(binarySecret.getValue()));
                    StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
                    continue;
                }
                if (content instanceof ComputedKeyType) {
                    ComputedKeyType computedKey = (ComputedKeyType)content;
                    StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"ComputedKey", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
                    StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)computedKey.getAlgorithm());
                    StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
                    continue;
                }
                throw new ProcessingException("PL00069: Parser: Type not supported:" + content);
            }
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if (response.getEntropy() != null) {
            EntropyType entropy = response.getEntropy();
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"Entropy", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            List<Object> entropyList = entropy.getAny();
            if (entropyList != null && entropyList.size() != 0) {
                for (Object entropyObj : entropyList) {
                    if (!(entropyObj instanceof BinarySecretType)) continue;
                    binarySecret = (BinarySecretType)entropyObj;
                    StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"BinarySecret", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
                    if (binarySecret.getType() != null) {
                        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"Type", (String)binarySecret.getType());
                    }
                    StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)new String(binarySecret.getValue()));
                    StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
                }
            }
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if (response.getStatus() != null) {
            StatusType status = response.getStatus();
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"Status", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            if (StringUtil.isNullOrEmpty((String)status.getCode())) {
                throw logger.wsTrustValidationStatusCodeMissing();
            }
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"Code", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)response.getStatus().getCode());
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
            if (status.getReason() != null) {
                StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"Reason", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
                StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)response.getStatus().getReason());
                StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
            }
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if (response.getRequestedTokenCancelled() != null) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"RequestedTokenCancelled", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if (response.getRenewing() != null) {
            RenewingType renewingType = response.getRenewing();
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wst", (String)"Renewing", (String)"http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"Allow", (String)("" + renewingType.isAllow()));
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"OK", (String)("" + renewingType.isOK()));
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }
}

