/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.persistence.impl.journal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.journal.impl.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.replication.ReplicatedJournal;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.jms.persistence.JMSStorageManager;
import org.apache.activemq.artemis.jms.persistence.config.PersistedBindings;
import org.apache.activemq.artemis.jms.persistence.config.PersistedConnectionFactory;
import org.apache.activemq.artemis.jms.persistence.config.PersistedDestination;
import org.apache.activemq.artemis.jms.persistence.config.PersistedType;
import org.apache.activemq.artemis.utils.IDGenerator;

public final class JMSJournalStorageManagerImpl
implements JMSStorageManager {
    public static final byte CF_RECORD = 1;
    public static final byte DESTINATION_RECORD = 2;
    public static final byte BINDING_RECORD = 3;
    private final IDGenerator idGenerator;
    private final String journalDir;
    private final boolean createDir;
    private final Journal jmsJournal;
    private volatile boolean started;
    private final Map<String, PersistedConnectionFactory> mapFactories = new ConcurrentHashMap<String, PersistedConnectionFactory>();
    private final Map<Pair<PersistedType, String>, PersistedDestination> destinations = new ConcurrentHashMap<Pair<PersistedType, String>, PersistedDestination>();
    private final Map<Pair<PersistedType, String>, PersistedBindings> mapBindings = new ConcurrentHashMap<Pair<PersistedType, String>, PersistedBindings>();

    public JMSJournalStorageManagerImpl(IDGenerator idGenerator, Configuration config, ReplicationManager replicator) {
        if (config.getJournalType() != JournalType.NIO && config.getJournalType() != JournalType.ASYNCIO) {
            throw new IllegalArgumentException("Only NIO and AsyncIO are supported journals");
        }
        this.journalDir = config.getBindingsDirectory();
        if (this.journalDir == null) {
            throw new NullPointerException("bindings-dir is null");
        }
        this.createDir = config.isCreateBindingsDir();
        NIOSequentialFileFactory bindingsJMS = new NIOSequentialFileFactory(this.journalDir);
        JournalImpl localJMS = new JournalImpl(0x100000, 2, config.getJournalCompactMinFiles(), config.getJournalCompactPercentage(), (SequentialFileFactory)bindingsJMS, "activemq-jms", "jms", 1);
        this.jmsJournal = replicator != null ? new ReplicatedJournal(2, (Journal)localJMS, replicator) : localJMS;
        this.idGenerator = idGenerator;
    }

    @Override
    public List<PersistedConnectionFactory> recoverConnectionFactories() {
        ArrayList<PersistedConnectionFactory> cfs = new ArrayList<PersistedConnectionFactory>(this.mapFactories.values());
        return cfs;
    }

    @Override
    public void storeConnectionFactory(PersistedConnectionFactory connectionFactory) throws Exception {
        this.deleteConnectionFactory(connectionFactory.getName());
        long id = this.idGenerator.generateID();
        connectionFactory.setId(id);
        this.jmsJournal.appendAddRecord(id, (byte)1, (EncodingSupport)connectionFactory, true);
        this.mapFactories.put(connectionFactory.getName(), connectionFactory);
    }

    @Override
    public void deleteConnectionFactory(String cfName) throws Exception {
        PersistedConnectionFactory oldCF = this.mapFactories.remove(cfName);
        if (oldCF != null) {
            this.jmsJournal.appendDeleteRecord(oldCF.getId(), false);
        }
    }

    @Override
    public List<PersistedDestination> recoverDestinations() {
        ArrayList<PersistedDestination> destinations = new ArrayList<PersistedDestination>(this.destinations.values());
        return destinations;
    }

    @Override
    public void storeDestination(PersistedDestination destination) throws Exception {
        this.deleteDestination(destination.getType(), destination.getName());
        long id = this.idGenerator.generateID();
        destination.setId(id);
        this.jmsJournal.appendAddRecord(id, (byte)2, (EncodingSupport)destination, true);
        this.destinations.put((Pair<PersistedType, String>)new Pair((Object)destination.getType(), (Object)destination.getName()), destination);
    }

    @Override
    public List<PersistedBindings> recoverPersistedBindings() throws Exception {
        ArrayList<PersistedBindings> list = new ArrayList<PersistedBindings>(this.mapBindings.values());
        return list;
    }

    @Override
    public void addBindings(PersistedType type, String name, String ... address) throws Exception {
        Pair key = new Pair((Object)type, (Object)name);
        long tx = this.idGenerator.generateID();
        PersistedBindings currentBindings = this.mapBindings.get(key);
        if (currentBindings != null) {
            this.jmsJournal.appendDeleteRecordTransactional(tx, currentBindings.getId());
        } else {
            currentBindings = new PersistedBindings(type, name);
        }
        this.mapBindings.put((Pair<PersistedType, String>)key, currentBindings);
        for (String adItem : address) {
            currentBindings.addBinding(adItem);
        }
        long newId = this.idGenerator.generateID();
        currentBindings.setId(newId);
        this.jmsJournal.appendAddRecordTransactional(tx, newId, (byte)3, (EncodingSupport)currentBindings);
        this.jmsJournal.appendCommitRecord(tx, true);
    }

    @Override
    public void deleteBindings(PersistedType type, String name, String address) throws Exception {
        Pair key = new Pair((Object)type, (Object)name);
        long tx = this.idGenerator.generateID();
        PersistedBindings currentBindings = this.mapBindings.get(key);
        if (currentBindings == null) {
            return;
        }
        this.jmsJournal.appendDeleteRecordTransactional(tx, currentBindings.getId());
        currentBindings.deleteBinding(address);
        if (currentBindings.getBindings().size() == 0) {
            this.mapBindings.remove(key);
        } else {
            long newId = this.idGenerator.generateID();
            currentBindings.setId(newId);
            this.jmsJournal.appendAddRecordTransactional(tx, newId, (byte)3, (EncodingSupport)currentBindings);
        }
        this.jmsJournal.appendCommitRecord(tx, true);
    }

    @Override
    public void deleteBindings(PersistedType type, String name) throws Exception {
        Pair key = new Pair((Object)type, (Object)name);
        PersistedBindings currentBindings = this.mapBindings.remove(key);
        if (currentBindings != null) {
            this.jmsJournal.appendDeleteRecord(currentBindings.getId(), true);
        }
    }

    @Override
    public void deleteDestination(PersistedType type, String name) throws Exception {
        PersistedDestination destination = this.destinations.remove(new Pair((Object)type, (Object)name));
        if (destination != null) {
            this.jmsJournal.appendDeleteRecord(destination.getId(), false);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() throws Exception {
        this.checkAndCreateDir(this.journalDir, this.createDir);
        this.jmsJournal.start();
        this.started = true;
    }

    public void stop() throws Exception {
        this.started = false;
        this.jmsJournal.stop();
    }

    @Override
    public void load() throws Exception {
        this.mapFactories.clear();
        ArrayList data = new ArrayList();
        ArrayList list = new ArrayList();
        this.jmsJournal.load(data, list, null);
        for (RecordInfo record : data) {
            long id = record.id;
            ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])record.data);
            byte rec = record.getUserRecordType();
            if (rec == 1) {
                PersistedConnectionFactory cf = new PersistedConnectionFactory();
                cf.decode(buffer);
                cf.setId(id);
                this.mapFactories.put(cf.getName(), cf);
                continue;
            }
            if (rec == 2) {
                PersistedDestination destination = new PersistedDestination();
                destination.decode(buffer);
                destination.setId(id);
                this.destinations.put((Pair<PersistedType, String>)new Pair((Object)destination.getType(), (Object)destination.getName()), destination);
                continue;
            }
            if (rec == 3) {
                PersistedBindings bindings = new PersistedBindings();
                bindings.decode(buffer);
                bindings.setId(id);
                Pair key = new Pair((Object)bindings.getType(), (Object)bindings.getName());
                this.mapBindings.put((Pair<PersistedType, String>)key, bindings);
                continue;
            }
            throw new IllegalStateException("Invalid record type " + rec);
        }
    }

    private void checkAndCreateDir(String dir, boolean create) {
        File f = new File(dir);
        if (!f.exists()) {
            if (create) {
                if (!f.mkdirs()) {
                    throw new IllegalStateException("Failed to create directory " + dir);
                }
            } else {
                throw new IllegalArgumentException("Directory " + dir + " does not exist and will not create it");
            }
        }
    }
}

