/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import org.jboss.aesh.terminal.CharacterType;
import org.jboss.aesh.terminal.Color;
import org.jboss.aesh.util.ANSI;

public class TerminalCharacter {
    private char character;
    private Color backgroundColor;
    private Color textColor;
    private CharacterType type;

    public TerminalCharacter(char c) {
        this(c, CharacterType.NORMAL);
    }

    public TerminalCharacter(char c, CharacterType type) {
        this.character = c;
        this.type = type;
        this.textColor = Color.DEFAULT_TEXT;
        this.backgroundColor = Color.DEFAULT_BG;
    }

    public TerminalCharacter(char c, Color background, Color text) {
        this(c, background, text, CharacterType.NORMAL);
    }

    public TerminalCharacter(char c, Color background, Color text, CharacterType type) {
        this(c, type);
        this.backgroundColor = background;
        this.textColor = text;
    }

    public char getCharacter() {
        return this.character;
    }

    public CharacterType getType() {
        return this.type;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public String getAsString(TerminalCharacter prev) {
        if (this.equalsIgnoreCharacter(prev)) {
            return String.valueOf(this.character);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(ANSI.getStart());
        builder.append(this.type.getValueComparedToPrev(prev.getType()));
        if (this.getTextColor() != prev.getTextColor() || prev.getType() == CharacterType.INVERT) {
            builder.append(';').append(this.getTextColor().getValue());
        }
        if (this.getBackgroundColor() != prev.getBackgroundColor() || prev.getType() == CharacterType.INVERT) {
            builder.append(';').append(this.getBackgroundColor().getValue());
        }
        builder.append('m');
        builder.append(this.getCharacter());
        return builder.toString();
    }

    public String getAsString() {
        StringBuilder builder = new StringBuilder();
        builder.append(ANSI.getStart());
        builder.append(this.type.getValue()).append(';');
        builder.append(this.getTextColor().getValue()).append(';');
        builder.append(this.getBackgroundColor().getValue());
        builder.append('m');
        builder.append(this.getCharacter());
        return builder.toString();
    }

    public boolean equalsIgnoreCharacter(TerminalCharacter that) {
        if (this.type != that.type) {
            return false;
        }
        if (this.backgroundColor != that.backgroundColor) {
            return false;
        }
        return this.textColor == that.textColor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TerminalCharacter)) {
            return false;
        }
        TerminalCharacter that = (TerminalCharacter)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.character != that.character) {
            return false;
        }
        if (this.backgroundColor != that.backgroundColor) {
            return false;
        }
        return this.textColor == that.textColor;
    }

    public int hashCode() {
        int result = this.character;
        result = 31 * result + this.backgroundColor.hashCode();
        result = 31 * result + this.textColor.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return "TerminalCharacter{character=" + this.character + ", backgroundColor=" + (Object)((Object)this.backgroundColor) + ", textColor=" + (Object)((Object)this.textColor) + ", type=" + (Object)((Object)this.type) + '}';
    }
}

