/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import io.undertow.server.ListenerRegistry;
import java.util.Collection;
import java.util.concurrent.Executor;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.http.server.ConsoleMode;
import org.jboss.as.domain.http.server.ManagementHttpRequestProcessor;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.host.controller.DomainModelControllerService;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.operations.HttpManagementRemoveHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.host.controller.operations.NativeManagementServices;
import org.jboss.as.host.controller.resources.HttpManagementResourceDefinition;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.remoting.HttpListenerRegistryService;
import org.jboss.as.remoting.RemotingHttpUpgradeService;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.mgmt.HttpManagementRequestsService;
import org.jboss.as.server.mgmt.HttpShutdownService;
import org.jboss.as.server.mgmt.UndertowHttpManagementService;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.RemotingOptions;
import org.xnio.OptionMap;

public class HttpManagementAddHandler
extends AbstractAddStepHandler {
    public static final String OPERATION_NAME = "add";
    private final LocalHostControllerInfoImpl hostControllerInfo;
    private final HostControllerEnvironment environment;

    public HttpManagementAddHandler(LocalHostControllerInfoImpl hostControllerInfo, HostControllerEnvironment environment) {
        super(HttpManagementResourceDefinition.HTTP_MANAGEMENT_CAPABILITY, HttpManagementResourceDefinition.ATTRIBUTE_DEFINITIONS);
        this.hostControllerInfo = hostControllerInfo;
        this.environment = environment;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        HttpManagementAddHandler.populateHostControllerInfo(this.hostControllerInfo, context, model);
        HttpManagementAddHandler.installHttpManagementServices(this.environment, this.hostControllerInfo, context, model);
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        HttpManagementRemoveHandler.clearHostControllerInfo(this.hostControllerInfo);
    }

    static void populateHostControllerInfo(LocalHostControllerInfoImpl hostControllerInfo, OperationContext context, ModelNode model) throws OperationFailedException {
        hostControllerInfo.setHttpManagementInterface(HttpManagementResourceDefinition.INTERFACE.resolveModelAttribute(context, model).asString());
        ModelNode portNode = HttpManagementResourceDefinition.HTTP_PORT.resolveModelAttribute(context, model);
        hostControllerInfo.setHttpManagementPort(portNode.isDefined() ? portNode.asInt() : -1);
        ModelNode secureAddress = HttpManagementResourceDefinition.SECURE_INTERFACE.resolveModelAttribute(context, model);
        hostControllerInfo.setHttpManagementSecureInterface(secureAddress.isDefined() ? secureAddress.asString() : null);
        ModelNode securePortNode = HttpManagementResourceDefinition.HTTPS_PORT.resolveModelAttribute(context, model);
        hostControllerInfo.setHttpManagementSecurePort(securePortNode.isDefined() ? securePortNode.asInt() : -1);
        ModelNode realmNode = HttpManagementResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model);
        hostControllerInfo.setHttpManagementSecurityRealm(realmNode.isDefined() ? realmNode.asString() : null);
        hostControllerInfo.setAllowedOrigins(HttpManagementResourceDefinition.ALLOWED_ORIGINS.unwrap((ExpressionResolver)context, model));
    }

    static void installHttpManagementServices(HostControllerEnvironment environment, LocalHostControllerInfo hostControllerInfo, OperationContext context, ModelNode model) throws OperationFailedException {
        boolean httpUpgrade = HttpManagementResourceDefinition.HTTP_UPGRADE_ENABLED.resolveModelAttribute(context, model).asBoolean();
        boolean onDemand = context.isBooting();
        OptionMap options = HttpManagementAddHandler.createConnectorOptions(context, model);
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        RunningMode runningMode = context.getRunningMode();
        ServiceTarget serviceTarget = context.getServiceTarget();
        String interfaceName = hostControllerInfo.getHttpManagementInterface();
        int port = hostControllerInfo.getHttpManagementPort();
        String secureInterfaceName = hostControllerInfo.getHttpManagementSecureInterface();
        int securePort = hostControllerInfo.getHttpManagementSecurePort();
        String securityRealm = hostControllerInfo.getHttpManagementSecurityRealm();
        Collection<String> allowedOrigins = hostControllerInfo.getAllowedOrigins();
        HostControllerLogger.ROOT_LOGGER.creatingHttpManagementService(interfaceName, port, securePort);
        boolean consoleEnabled = HttpManagementResourceDefinition.CONSOLE_ENABLED.resolveModelAttribute(context, model).asBoolean();
        ConsoleMode consoleMode = consoleEnabled ? (context.getRunningMode() == RunningMode.ADMIN_ONLY ? ConsoleMode.ADMIN_ONLY : ConsoleMode.CONSOLE) : ConsoleMode.NO_CONSOLE;
        ServiceName requestProcessorName = UndertowHttpManagementService.SERVICE_NAME.append(new String[]{"requests"});
        HttpManagementRequestsService.installService((ServiceName)requestProcessorName, (ServiceTarget)serviceTarget);
        UndertowHttpManagementService service = new UndertowHttpManagementService(consoleMode, environment.getProductConfig().getConsoleSlot());
        ServiceBuilder builder = serviceTarget.addService(UndertowHttpManagementService.SERVICE_NAME, (Service)service).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceName}), NetworkInterfaceBinding.class, service.getInterfaceInjector()).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{secureInterfaceName}), NetworkInterfaceBinding.class, service.getSecureInterfaceInjector()).addDependency(DomainModelControllerService.SERVICE_NAME, ModelController.class, service.getModelControllerInjector()).addDependency(ControlledProcessStateService.SERVICE_NAME, ControlledProcessStateService.class, (Injector)service.getControlledProcessStateServiceInjector()).addDependency(HttpListenerRegistryService.SERVICE_NAME, ListenerRegistry.class, (Injector)service.getListenerRegistry()).addDependency(requestProcessorName, ManagementHttpRequestProcessor.class, (Injector)service.getRequestProcessorValue()).addInjection(service.getPortInjector(), (Object)port).addInjection(service.getSecurePortInjector(), (Object)securePort).addInjection((Injector)service.getAllowedOriginsInjector(), allowedOrigins);
        if (securityRealm != null) {
            SecurityRealm.ServiceUtil.addDependency((ServiceBuilder)builder, (Injector)service.getSecurityRealmInjector(), (String)securityRealm, (boolean)false);
        } else {
            HostControllerLogger.ROOT_LOGGER.noSecurityRealmDefined();
        }
        builder.setInitialMode(onDemand ? ServiceController.Mode.ON_DEMAND : ServiceController.Mode.ACTIVE).install();
        HttpShutdownService shutdownService = new HttpShutdownService();
        ServiceName shutdownName = UndertowHttpManagementService.SERVICE_NAME.append(new String[]{"shutdown"});
        ServiceController shutdown = serviceTarget.addService(shutdownName, (Service)shutdownService).addDependency(requestProcessorName, ManagementHttpRequestProcessor.class, (Injector)shutdownService.getProcessorValue()).addDependency(HostControllerService.HC_EXECUTOR_SERVICE_NAME, Executor.class, (Injector)shutdownService.getExecutorValue()).addDependency(ManagementChannelRegistryService.SERVICE_NAME, ManagementChannelRegistryService.class, (Injector)shutdownService.getMgmtChannelRegistry()).addDependency(UndertowHttpManagementService.SERVICE_NAME).setInitialMode(ServiceController.Mode.ACTIVE).install();
        if (httpUpgrade) {
            ServiceName serverCallbackService = ServiceName.JBOSS.append(new String[]{"host", "controller", "server-inventory", "callback"});
            ServiceName tmpDirPath = ServiceName.JBOSS.append(new String[]{"server", "path", "jboss.domain.temp.dir"});
            ManagementRemotingServices.installSecurityServices((ServiceTarget)serviceTarget, (String)"http-management", (String)securityRealm, (ServiceName)serverCallbackService, (ServiceName)tmpDirPath);
            NativeManagementServices.installRemotingServicesIfNotInstalled(serviceTarget, hostControllerInfo.getLocalHostName(), serviceRegistry, onDemand);
            String httpConnectorName = port > -1 || securePort < 0 ? "http-management" : "https-management";
            RemotingHttpUpgradeService.installServices((ServiceTarget)serviceTarget, (String)"http-management", (String)httpConnectorName, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (OptionMap)options);
        }
    }

    static OptionMap createConnectorOptions(OperationContext context, ModelNode model) throws OperationFailedException {
        OptionMap.Builder builder = OptionMap.builder();
        builder.set(RemotingOptions.SASL_PROTOCOL, (Object)HttpManagementResourceDefinition.SASL_PROTOCOL.resolveModelAttribute(context, model).asString());
        ModelNode serverName = HttpManagementResourceDefinition.SERVER_NAME.resolveModelAttribute(context, model);
        if (serverName.isDefined()) {
            builder.set(RemotingOptions.SERVER_NAME, (Object)serverName.asString());
        }
        return builder.getMap();
    }
}

