/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.orbspecific.interposition.resources;

import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.orbspecific.interposition.coordinator.ServerTransaction;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationHelper;
import org.omg.CosTransactions.SynchronizationPOA;

public class ServerSynchronization
extends SynchronizationPOA {
    private ServerTransaction _theTransaction;
    private Synchronization _theSynchronization;

    public ServerSynchronization(ServerTransaction topLevel) {
        ORBManager.getPOA().objectIsReady(this);
        this._theTransaction = topLevel;
        this._theSynchronization = SynchronizationHelper.narrow(ORBManager.getPOA().corbaReference(this));
    }

    public final Synchronization getSynchronization() {
        return this._theSynchronization;
    }

    public void destroy() {
        try {
            ORBManager.getPOA().shutdownObject(this);
        }
        catch (Exception e) {
            jtsLogger.i18NLogger.warn_orbspecific_interposition_resources_destroyfailed();
        }
    }

    @Override
    public void before_completion() throws SystemException {
        if (this._theTransaction == null) {
            throw new BAD_OPERATION(40005, CompletionStatus.COMPLETED_NO);
        }
        this._theTransaction.doBeforeCompletion();
    }

    @Override
    public void after_completion(Status status) throws SystemException {
        if (this._theTransaction == null) {
            this.destroy();
            throw new BAD_OPERATION(40005, CompletionStatus.COMPLETED_NO);
        }
        Status myStatus = Status.StatusUnknown;
        try {
            myStatus = this._theTransaction.get_status();
        }
        catch (Exception e) {
            myStatus = Status.StatusUnknown;
        }
        if (myStatus != status) {
            jtsLogger.i18NLogger.warn_orbspecific_interposition_resources_stateerror("ServerSynchronization.after_completion", Utility.stringStatus(myStatus), Utility.stringStatus(status));
            if (myStatus == Status.StatusActive) {
                try {
                    this._theTransaction.rollback();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    status = this._theTransaction.get_status();
                }
                catch (Exception e) {
                    status = Status.StatusUnknown;
                }
            }
        }
        this._theTransaction.doAfterCompletion(status);
        this.destroy();
    }
}

