/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.net.URI;
import org.wildfly.security.auth.MatchRule;

class MatchPortRule
extends MatchRule {
    private final int port;

    MatchPortRule(MatchRule parent, int port) {
        super(parent);
        this.port = port;
    }

    @Override
    public boolean matches(URI uri) {
        return uri.getPort() == this.port && super.matches(uri);
    }

    @Override
    MatchRule reparent(MatchRule newParent) {
        return new MatchPortRule(newParent, this.port);
    }

    @Override
    boolean halfEqual(MatchRule other) {
        return other.getMatchPort() == this.port && this.parentHalfEqual(other);
    }

    @Override
    public int hashCode() {
        return 7919 * this.port + this.parentHashCode();
    }

    @Override
    StringBuilder asString(StringBuilder b) {
        return this.parentAsString(b).append("port=").append(this.port).append(',');
    }
}

