/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.process;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.web.core.HTTPContext;

public class SAMLHandlerChainProcessor {
    private final Set<SAML2Handler> handlers = new LinkedHashSet<SAML2Handler>();
    private final PicketLinkType configuration;

    public SAMLHandlerChainProcessor(Set<SAML2Handler> handlers, PicketLinkType configuration) {
        this.handlers.addAll(handlers);
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callHandlerChain(SAML2Object samlObject, SAML2HandlerRequest saml2HandlerRequest, SAML2HandlerResponse saml2HandlerResponse, HTTPContext httpContext, Lock chainLock) throws ProcessingException, IOException {
        try {
            if (this.configuration.getHandlers().isLocking()) {
                chainLock.lock();
            }
            for (SAML2Handler handler : this.handlers) {
                if (saml2HandlerResponse.isInError()) {
                    httpContext.getResponse().sendError(saml2HandlerResponse.getErrorCode());
                    break;
                }
                if (samlObject instanceof RequestAbstractType) {
                    handler.handleRequestType(saml2HandlerRequest, saml2HandlerResponse);
                    continue;
                }
                handler.handleStatusResponseType(saml2HandlerRequest, saml2HandlerResponse);
            }
        }
        finally {
            if (this.configuration.getHandlers().isLocking()) {
                chainLock.unlock();
            }
        }
    }
}

