/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import java.security.PrivateKey;
import java.security.PublicKey;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.security.doseta.DKIMSignature;
import org.jboss.resteasy.security.doseta.DosetaKeyRepository;
import org.jboss.resteasy.security.doseta.KeyRepository;
import org.jboss.resteasy.spi.ResteasyConfiguration;

public class ConfiguredDosetaKeyRepository
implements KeyRepository {
    public static String RESTEASY_KEY_STORE_FILE_NAME = "resteasy.doseta.keystore.filename";
    public static String RESTEASY_KEY_STORE_CLASSPATH = "resteasy.doseta.keystore.classpath";
    public static String RESTEASY_KEY_STORE_PASSWORD = "resteasy.doseta.keystore.password";
    public static String RESTEASY_DOSETA_USE_DNS = "resteasy.doseta.use.dns";
    public static String RESTEASY_DOSETA_DNS_URI = "resteasy.doseta.dns.uri";
    public static String RESTEASY_DOSETA_DEFAULT_PRIVATE_DOMAIN = "resteasy.doseta.default.private.domain";
    public static String RESTEASY_DOSETA_CACHE_TIMEOUT = "resteasy.doseta.cache.timeout";
    public static String RESTEASY_DOSETA_PRINCIPAL_FOR_PRIVATE = "resteasy.doseta.principal.for.private";
    protected DosetaKeyRepository keyRepository = new DosetaKeyRepository();

    private static String getVariable(ResteasyConfiguration config, String name) {
        String variable = config.getParameter(name);
        if (variable != null) {
            variable = variable.trim();
        }
        return variable;
    }

    public ConfiguredDosetaKeyRepository(@Context ResteasyConfiguration config) {
        String dnsUri;
        String useDns;
        String password = ConfiguredDosetaKeyRepository.getVariable(config, RESTEASY_KEY_STORE_PASSWORD);
        this.keyRepository.setKeyStorePassword(password);
        String keyStoreFileName = ConfiguredDosetaKeyRepository.getVariable(config, RESTEASY_KEY_STORE_FILE_NAME);
        this.keyRepository.setKeyStoreFile(keyStoreFileName);
        String keyStorePath = ConfiguredDosetaKeyRepository.getVariable(config, RESTEASY_KEY_STORE_CLASSPATH);
        this.keyRepository.setKeyStorePath(keyStorePath);
        String principal = ConfiguredDosetaKeyRepository.getVariable(config, RESTEASY_DOSETA_PRINCIPAL_FOR_PRIVATE);
        if (principal != null) {
            this.keyRepository.setUserPrincipalAsPrivateSelector(Boolean.parseBoolean(principal));
        }
        if ((useDns = ConfiguredDosetaKeyRepository.getVariable(config, RESTEASY_DOSETA_USE_DNS)) != null) {
            this.keyRepository.setUseDns(Boolean.parseBoolean(useDns));
        }
        if ((dnsUri = ConfiguredDosetaKeyRepository.getVariable(config, RESTEASY_DOSETA_DNS_URI)) != null) {
            this.keyRepository.setDnsUri(dnsUri.trim());
        }
        String defaultDomain = ConfiguredDosetaKeyRepository.getVariable(config, RESTEASY_DOSETA_DEFAULT_PRIVATE_DOMAIN);
        this.keyRepository.setDefaultPrivateDomain(defaultDomain);
        String timeout = ConfiguredDosetaKeyRepository.getVariable(config, RESTEASY_DOSETA_CACHE_TIMEOUT);
        if (timeout != null) {
            this.keyRepository.setCacheTimeout(Long.parseLong(timeout.trim()));
        }
        this.keyRepository.start();
    }

    @Override
    public PrivateKey findPrivateKey(DKIMSignature header) {
        return this.keyRepository.findPrivateKey(header);
    }

    @Override
    public PublicKey findPublicKey(DKIMSignature header) {
        return this.keyRepository.findPublicKey(header);
    }

    @Override
    public String getDefaultPrivateSelector() {
        return this.keyRepository.getDefaultPrivateSelector();
    }

    @Override
    public String getDefaultPrivateDomain() {
        return this.keyRepository.getDefaultPrivateDomain();
    }
}

