/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import java.util.List;
import javax.batch.runtime.BatchStatus;
import org.jberet._private.BatchLogger;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobElement;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.context.JobContextImpl;
import org.jberet.runtime.runner.CompositeExecutionRunner;

public final class JobExecutionRunner
extends CompositeExecutionRunner<JobContextImpl>
implements Runnable {
    private final Job job;

    public JobExecutionRunner(JobContextImpl jobContext) {
        super(jobContext, null);
        this.job = jobContext.getJob();
    }

    @Override
    protected List<? extends JobElement> getJobElements() {
        return this.job.getJobElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int i;
        JobExecutionImpl jobExecution = ((JobContextImpl)this.batchContext).getJobExecution();
        if (jobExecution.getBatchStatus() != BatchStatus.STOPPING) {
            jobExecution.setBatchStatus(BatchStatus.STARTED);
            ((JobContextImpl)this.batchContext).getJobRepository().updateJobExecution(jobExecution, false, false);
        }
        Object[] jobListeners = ((JobContextImpl)this.batchContext).getJobListeners();
        try {
            for (i = 0; i < jobListeners.length; ++i) {
                jobListeners[i].beforeJob();
            }
            this.runFromHeadOrRestartPoint(jobExecution.getRestartPosition());
        }
        catch (Throwable e) {
            BatchLogger.LOGGER.failToRunJob(e, this.job.getId(), "", this.job);
            jobExecution.setBatchStatus(BatchStatus.FAILED);
        }
        finally {
            for (i = 0; i < jobListeners.length; ++i) {
                try {
                    jobListeners[i].afterJob();
                    continue;
                }
                catch (Throwable e) {
                    BatchLogger.LOGGER.failToRunJob(e, this.job.getId(), "", jobListeners[i]);
                    jobExecution.setBatchStatus(BatchStatus.FAILED);
                }
            }
        }
        ((JobContextImpl)this.batchContext).destroyArtifact(jobListeners);
        BatchStatus batchStatus = jobExecution.getBatchStatus();
        boolean saveJobParameters = false;
        if (batchStatus == BatchStatus.STARTED) {
            jobExecution.setBatchStatus(BatchStatus.COMPLETED);
        } else if (batchStatus == BatchStatus.STOPPING) {
            jobExecution.setBatchStatus(BatchStatus.STOPPED);
            saveJobParameters = this.adjustRestartFailedOrStopped(jobExecution);
        } else if (batchStatus == BatchStatus.FAILED) {
            saveJobParameters = this.adjustRestartFailedOrStopped(jobExecution);
        } else if (batchStatus == BatchStatus.STOPPED) {
            saveJobParameters = this.adjustRestartFailedOrStopped(jobExecution);
        }
        ((JobContextImpl)this.batchContext).getJobRepository().updateJobExecution(jobExecution, true, saveJobParameters);
        ((JobContextImpl)this.batchContext).setTransientUserData(null);
        jobExecution.cleanUp();
    }

    private boolean adjustRestartFailedOrStopped(JobExecutionImpl jobExecution) {
        if (!this.job.getRestartableBoolean()) {
            jobExecution.setRestartPosition("jberet.unrestartable");
        }
        if (this.job.getJobXmlName() != null) {
            jobExecution.addJobParameter("jberet.jobXmlName", this.job.getJobXmlName());
            return true;
        }
        return false;
    }
}

