/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.som.cff;

import com.sun.tools.corba.se.idl.som.cff.NamedDataInputStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public abstract class FileLocator {
    static final Properties pp = System.getProperties();
    static final String classPath = pp.getProperty("java.class.path", ".");
    static final String pathSeparator = pp.getProperty("path.separator", ";");

    public static DataInputStream locateClassFile(String classFileName) throws FileNotFoundException, IOException {
        NamedDataInputStream result;
        boolean notFound = true;
        String path = "";
        File cf = null;
        StringTokenizer st = new StringTokenizer(classPath, pathSeparator, false);
        String pathNameForm = classFileName.replace('.', File.separatorChar) + ".class";
        while (st.hasMoreTokens() && notFound) {
            String pathLast4;
            try {
                path = st.nextToken();
            }
            catch (NoSuchElementException nse) {
                break;
            }
            int pLen = path.length();
            String string = pathLast4 = pLen > 3 ? path.substring(pLen - 4) : "";
            if (pathLast4.equalsIgnoreCase(".zip") || pathLast4.equalsIgnoreCase(".jar")) {
                try {
                    result = FileLocator.locateInZipFile(path, classFileName, true, true);
                    if (result == null) continue;
                    return result;
                }
                catch (ZipException zfe) {
                    continue;
                }
                catch (IOException ioe) {
                    continue;
                }
            }
            try {
                cf = new File(path + File.separator + pathNameForm);
            }
            catch (NullPointerException npe) {
                continue;
            }
            if (cf == null || !cf.exists()) continue;
            notFound = false;
        }
        if (notFound) {
            int lastdot = classFileName.lastIndexOf(46);
            String simpleName = lastdot >= 0 ? classFileName.substring(lastdot + 1) : classFileName;
            result = new NamedDataInputStream(new BufferedInputStream(new FileInputStream(simpleName + ".class")), simpleName + ".class", false);
            return result;
        }
        result = new NamedDataInputStream(new BufferedInputStream(new FileInputStream(cf)), path + File.separator + pathNameForm, false);
        return result;
    }

    public static DataInputStream locateLocaleSpecificFileInClassPath(String fileName) throws FileNotFoundException, IOException {
        String fnEnd;
        String fnFront;
        String localeSuffix = "_" + Locale.getDefault().toString();
        int lastSlash = fileName.lastIndexOf(47);
        int lastDot = fileName.lastIndexOf(46);
        DataInputStream result = null;
        boolean lastAttempt = false;
        if (lastDot > 0 && lastDot > lastSlash) {
            fnFront = fileName.substring(0, lastDot);
            fnEnd = fileName.substring(lastDot);
        } else {
            fnFront = fileName;
            fnEnd = "";
        }
        while (true) {
            if (lastAttempt) {
                result = FileLocator.locateFileInClassPath(fileName);
            } else {
                try {
                    result = FileLocator.locateFileInClassPath(fnFront + localeSuffix + fnEnd);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (result != null || lastAttempt) break;
            int lastUnderbar = localeSuffix.lastIndexOf(95);
            if (lastUnderbar > 0) {
                localeSuffix = localeSuffix.substring(0, lastUnderbar);
                continue;
            }
            lastAttempt = true;
        }
        return result;
    }

    public static DataInputStream locateFileInClassPath(String fileName) throws FileNotFoundException, IOException {
        NamedDataInputStream result;
        boolean notFound = true;
        String path = "";
        File cf = null;
        String zipEntryName = File.separatorChar == '/' ? fileName : fileName.replace(File.separatorChar, '/');
        String localFileName = File.separatorChar == '/' ? fileName : fileName.replace('/', File.separatorChar);
        StringTokenizer st = new StringTokenizer(classPath, pathSeparator, false);
        while (st.hasMoreTokens() && notFound) {
            String pathLast4;
            try {
                path = st.nextToken();
            }
            catch (NoSuchElementException nse) {
                break;
            }
            int pLen = path.length();
            String string = pathLast4 = pLen > 3 ? path.substring(pLen - 4) : "";
            if (pathLast4.equalsIgnoreCase(".zip") || pathLast4.equalsIgnoreCase(".jar")) {
                try {
                    result = FileLocator.locateInZipFile(path, zipEntryName, false, false);
                    if (result == null) continue;
                    return result;
                }
                catch (ZipException zfe) {
                    continue;
                }
                catch (IOException ioe) {
                    continue;
                }
            }
            try {
                cf = new File(path + File.separator + localFileName);
            }
            catch (NullPointerException npe) {
                continue;
            }
            if (cf == null || !cf.exists()) continue;
            notFound = false;
        }
        if (notFound) {
            int lastpart = localFileName.lastIndexOf(File.separator);
            String simpleName = lastpart >= 0 ? localFileName.substring(lastpart + 1) : localFileName;
            result = new NamedDataInputStream(new BufferedInputStream(new FileInputStream(simpleName)), simpleName, false);
            return result;
        }
        result = new NamedDataInputStream(new BufferedInputStream(new FileInputStream(cf)), path + File.separator + localFileName, false);
        return result;
    }

    public static String getFileNameFromStream(DataInputStream ds) {
        if (ds instanceof NamedDataInputStream) {
            return ((NamedDataInputStream)ds).fullyQualifiedFileName;
        }
        return "";
    }

    public static boolean isZipFileAssociatedWithStream(DataInputStream ds) {
        if (ds instanceof NamedDataInputStream) {
            return ((NamedDataInputStream)ds).inZipFile;
        }
        return false;
    }

    private static NamedDataInputStream locateInZipFile(String zipFileName, String fileName, boolean wantClass, boolean buffered) throws ZipException, IOException {
        ZipFile zf = new ZipFile(zipFileName);
        if (zf == null) {
            return null;
        }
        String zeName = wantClass ? fileName.replace('.', '/') + ".class" : fileName;
        ZipEntry ze = zf.getEntry(zeName);
        if (ze == null) {
            zf.close();
            zf = null;
            return null;
        }
        InputStream istream = zf.getInputStream(ze);
        if (buffered) {
            istream = new BufferedInputStream(istream);
        }
        return new NamedDataInputStream(istream, zipFileName + '(' + zeName + ')', true);
    }
}

