/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms.bridge;

import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyResourceDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.messaging.AttributeMarshallers;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.jms.bridge.InfiniteOrPositiveValidators;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JMSBridgeDefinition
extends ModelOnlyResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"jms-bridge");
    public static final String SOURCE = "source";
    public static final String TARGET = "target";
    public static final String CONTEXT = "context";
    public static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"module", (ModelType)ModelType.STRING).setAllowNull(true)).build();
    public static final SimpleAttributeDefinition SOURCE_CONNECTION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-connection-factory", (ModelType)ModelType.STRING).setXmlName("connection-factory")).setAttributeMarshaller(AttributeMarshallers.JNDI_RESOURCE_MARSHALLER)).build();
    public static final SimpleAttributeDefinition SOURCE_DESTINATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-destination", (ModelType)ModelType.STRING).setXmlName("destination")).setAttributeMarshaller(AttributeMarshallers.JNDI_RESOURCE_MARSHALLER)).build();
    public static final SimpleAttributeDefinition SOURCE_USER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-user", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).setXmlName("user")).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)CommonAttributes.MESSAGING_SECURITY_DEF)).build();
    public static final SimpleAttributeDefinition SOURCE_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-password", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).setXmlName("password")).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)CommonAttributes.MESSAGING_SECURITY_DEF)).build();
    public static final PropertiesAttributeDefinition SOURCE_CONTEXT = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("source-context", true).setXmlName("context").setAllowExpression(true)).setAttributeMarshaller(AttributeMarshallers.JNDI_CONTEXT_MARSHALLER)).build();
    public static final SimpleAttributeDefinition TARGET_CONNECTION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"target-connection-factory", (ModelType)ModelType.STRING).setXmlName("connection-factory")).setAttributeMarshaller(AttributeMarshallers.JNDI_RESOURCE_MARSHALLER)).build();
    public static final SimpleAttributeDefinition TARGET_DESTINATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"target-destination", (ModelType)ModelType.STRING).setXmlName("destination")).setAttributeMarshaller(AttributeMarshallers.JNDI_RESOURCE_MARSHALLER)).build();
    public static final SimpleAttributeDefinition TARGET_USER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"target-user", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).setXmlName("user")).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)CommonAttributes.MESSAGING_SECURITY_DEF)).build();
    public static final SimpleAttributeDefinition TARGET_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"target-password", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).setXmlName("password")).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)CommonAttributes.MESSAGING_SECURITY_DEF)).build();
    public static final PropertiesAttributeDefinition TARGET_CONTEXT = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("target-context", true).setXmlName("context").setAllowExpression(true)).setAttributeMarshaller(AttributeMarshallers.JNDI_CONTEXT_MARSHALLER)).build();
    public static final SimpleAttributeDefinition QUALITY_OF_SERVICE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"quality-of-service", (ModelType)ModelType.STRING).setValidator((ParameterValidator)new EnumValidator(QualityOfServiceMode.class, false, false))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition FAILURE_RETRY_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"failure-retry-interval", (ModelType)ModelType.LONG).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.LONG_INSTANCE)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MAX_RETRIES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-retries", (ModelType)ModelType.INT).setValidator((ParameterValidator)InfiniteOrPositiveValidators.INT_INSTANCE)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MAX_BATCH_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-batch-size", (ModelType)ModelType.INT).setValidator((ParameterValidator)new IntRangeValidator(0, Integer.MAX_VALUE, false, false))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MAX_BATCH_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-batch-time", (ModelType)ModelType.LONG).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.LONG_INSTANCE)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition SUBSCRIPTION_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"subscription-name", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition CLIENT_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"client-id", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition ADD_MESSAGE_ID_IN_HEADER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"add-messageID-in-header", (ModelType)ModelType.BOOLEAN).setAllowNull(true)).setDefaultValue(new ModelNode().set(false))).setAllowExpression(true)).build();
    public static final AttributeDefinition[] JMS_BRIDGE_ATTRIBUTES = new AttributeDefinition[]{MODULE, QUALITY_OF_SERVICE, FAILURE_RETRY_INTERVAL, MAX_RETRIES, MAX_BATCH_SIZE, MAX_BATCH_TIME, CommonAttributes.SELECTOR, SUBSCRIPTION_NAME, CLIENT_ID, ADD_MESSAGE_ID_IN_HEADER};
    public static final AttributeDefinition[] JMS_SOURCE_ATTRIBUTES = new AttributeDefinition[]{SOURCE_CONNECTION_FACTORY, SOURCE_DESTINATION, SOURCE_USER, SOURCE_PASSWORD, SOURCE_CONTEXT};
    public static final AttributeDefinition[] JMS_TARGET_ATTRIBUTES = new AttributeDefinition[]{TARGET_CONNECTION_FACTORY, TARGET_DESTINATION, TARGET_USER, TARGET_PASSWORD, TARGET_CONTEXT};
    public static final JMSBridgeDefinition INSTANCE = new JMSBridgeDefinition();

    private static AttributeDefinition[] getAllAttributes() {
        ArrayList<AttributeDefinition> allAttributes = new ArrayList<AttributeDefinition>();
        allAttributes.addAll(Arrays.asList(JMS_BRIDGE_ATTRIBUTES));
        allAttributes.addAll(Arrays.asList(JMS_SOURCE_ATTRIBUTES));
        allAttributes.addAll(Arrays.asList(JMS_TARGET_ATTRIBUTES));
        return allAttributes.toArray(new AttributeDefinition[allAttributes.size()]);
    }

    private JMSBridgeDefinition() {
        super(PATH, MessagingExtension.getResourceDescriptionResolver("jms-bridge"), JMSBridgeDefinition.getAllAttributes());
        this.setDeprecated(MessagingExtension.DEPRECATED_SINCE);
    }

    private static enum QualityOfServiceMode {
        AT_MOST_ONCE(0),
        DUPLICATES_OK(1),
        ONCE_AND_ONLY_ONCE(2);

        private final int value;

        private QualityOfServiceMode(int value) {
            this.value = value;
        }
    }
}

