/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class DelegateClassLoader
extends SecureClassLoader {
    private final ClassLoader delegate;
    private final ClassLoader parent;

    public DelegateClassLoader(ClassLoader delegate, ClassLoader parent) {
        super(parent);
        this.delegate = delegate;
        this.parent = parent;
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        if (this.parent != null) {
            try {
                return this.parent.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.delegate.loadClass(className);
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this.parent != null) {
            url = this.parent.getResource(name);
        }
        return url == null ? this.delegate.getResource(name) : url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final ArrayList<Enumeration<URL>> foundResources = new ArrayList<Enumeration<URL>>();
        foundResources.add(this.delegate.getResources(name));
        if (this.parent != null) {
            foundResources.add(this.parent.getResources(name));
        }
        return new Enumeration<URL>(){
            private int position;
            {
                this.position = foundResources.size() - 1;
            }

            @Override
            public boolean hasMoreElements() {
                while (this.position >= 0) {
                    if (((Enumeration)foundResources.get(this.position)).hasMoreElements()) {
                        return true;
                    }
                    --this.position;
                }
                return false;
            }

            @Override
            public URL nextElement() {
                while (this.position >= 0) {
                    try {
                        return (URL)((Enumeration)foundResources.get(this.position)).nextElement();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        --this.position;
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = this.parent.getResourceAsStream(name);
        return is == null ? this.delegate.getResourceAsStream(name) : is;
    }
}

