/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DataLocality;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InvalidateL1Command
extends InvalidateCommand {
    public static final int COMMAND_ID = 7;
    private static final Log log = LogFactory.getLog(InvalidateL1Command.class);
    private DistributionManager dm;
    private DataContainer dataContainer;
    private Configuration config;
    private Address writeOrigin;

    public InvalidateL1Command() {
        this.writeOrigin = null;
    }

    public InvalidateL1Command(DataContainer dc, Configuration config, DistributionManager dm, CacheNotifier notifier, Set<Flag> flags, Object ... keys) {
        super(notifier, flags, keys);
        this.writeOrigin = null;
        this.dm = dm;
        this.dataContainer = dc;
        this.config = config;
    }

    public InvalidateL1Command(DataContainer dc, Configuration config, DistributionManager dm, CacheNotifier notifier, Set<Flag> flags, Collection<Object> keys) {
        this(null, dc, config, dm, notifier, flags, keys);
    }

    public InvalidateL1Command(Address writeOrigin, DataContainer dc, Configuration config, DistributionManager dm, CacheNotifier notifier, Set<Flag> flags, Collection<Object> keys) {
        super(notifier, flags, keys);
        this.writeOrigin = writeOrigin;
        this.dm = dm;
        this.dataContainer = dc;
        this.config = config;
    }

    @Override
    public byte getCommandId() {
        return 7;
    }

    public void init(Configuration config, DistributionManager dm, CacheNotifier n, DataContainer dc) {
        super.init(n, config);
        this.dm = dm;
        this.config = config;
        this.dataContainer = dc;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.tracef("Preparing to invalidate keys %s", Arrays.asList(this.keys));
        }
        for (Object k : this.getKeys()) {
            InternalCacheEntry ice = this.dataContainer.get(k);
            if (ice == null) continue;
            DataLocality locality = this.dm.getLocality(k);
            if (!locality.isLocal()) {
                if (trace) {
                    log.tracef("Invalidating key %s.", k);
                }
                this.invalidate(ctx, k);
                continue;
            }
            log.tracef("Not invalidating key %s as it is local now", k);
        }
        return null;
    }

    public void setKeys(Object[] keys) {
        this.keys = keys;
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        if (ctx.isOriginLocal()) {
            return true;
        }
        for (Object k : this.getKeys()) {
            DataLocality locality = this.dm.getLocality(k);
            if (locality.isLocal() && !locality.isUncertain()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] getParameters() {
        if (this.keys == null || this.keys.length == 0) {
            return new Object[]{this.writeOrigin, 0};
        }
        if (this.keys.length == 1) {
            return new Object[]{this.writeOrigin, 1, this.keys[0]};
        }
        Object[] retval = new Object[this.keys.length + 2];
        retval[0] = this.writeOrigin;
        retval[1] = this.keys.length;
        System.arraycopy(this.keys, 0, retval, 2, this.keys.length);
        return retval;
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        this.writeOrigin = (Address)args[0];
        int size = (Integer)args[1];
        this.keys = new Object[size];
        if (size == 1) {
            this.keys[0] = args[2];
        } else if (size > 0) {
            System.arraycopy(args, 2, this.keys, 0, size);
        }
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitInvalidateL1Command(ctx, this);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "num keys=" + (this.keys == null ? 0 : this.keys.length) + ", origin=" + this.writeOrigin + '}';
    }

    public boolean isCausedByALocalWrite(Address address) {
        return this.writeOrigin != null && this.writeOrigin.equals(address);
    }
}

