/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.hibernate.search.engine.impl.DynamicShardingEntityIndexBinding;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.store.ShardIdentifierProvider;

class DynamicShardingStrategy
implements IndexShardingStrategy {
    private final ShardIdentifierProvider shardIdentifierProvider;
    private final IndexManagerHolder indexManagerHolder;
    private final String rootIndexName;
    private final DynamicShardingEntityIndexBinding entityIndexBinding;

    DynamicShardingStrategy(ShardIdentifierProvider shardIdentifierProvider, IndexManagerHolder indexManagerHolder, DynamicShardingEntityIndexBinding entityIndexBinding, String rootIndexName) {
        this.shardIdentifierProvider = shardIdentifierProvider;
        this.indexManagerHolder = indexManagerHolder;
        this.entityIndexBinding = entityIndexBinding;
        this.rootIndexName = rootIndexName;
    }

    @Override
    public void initialize(Properties properties, IndexManager[] indexManagers) {
    }

    @Override
    public IndexManager[] getIndexManagersForAllShards() {
        Set<String> allShardIdentifiers = this.shardIdentifierProvider.getAllShardIdentifiers();
        return this.getIndexManagersFromShards(allShardIdentifiers);
    }

    @Override
    public IndexManager getIndexManagerForAddition(Class<?> entity, Serializable id, String idInString, Document document) {
        String shardIdentifier = this.shardIdentifierProvider.getShardIdentifier(entity, id, idInString, document);
        return this.indexManagerHolder.getOrCreateIndexManager(this.rootIndexName, shardIdentifier, this.entityIndexBinding);
    }

    @Override
    public IndexManager[] getIndexManagersForDeletion(Class<?> entity, Serializable id, String idInString) {
        Set<String> shardIdentifiers = this.shardIdentifierProvider.getAllShardIdentifiers();
        return this.getIndexManagersFromShards(shardIdentifiers);
    }

    @Override
    public IndexManager[] getIndexManagersForQuery(FullTextFilterImplementor[] fullTextFilters) {
        Set<String> shards = this.shardIdentifierProvider.getShardIdentifiersForQuery(fullTextFilters);
        return this.getIndexManagersFromShards(shards);
    }

    ShardIdentifierProvider getShardIdentifierProvider() {
        return this.shardIdentifierProvider;
    }

    private IndexManager[] getIndexManagersFromShards(Set<String> shardIdentifiers) {
        HashSet<IndexManager> managers = new HashSet<IndexManager>(shardIdentifiers.size());
        for (String shardIdentifier : shardIdentifiers) {
            managers.add(this.indexManagerHolder.getOrCreateIndexManager(this.rootIndexName, shardIdentifier, this.entityIndexBinding));
        }
        return managers.toArray(new IndexManager[shardIdentifiers.size()]);
    }
}

