/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsat.server;

import com.arjuna.webservices11.ServiceRegistry;
import org.jboss.jbossts.xts.environment.WSCEnvironmentBean;
import org.jboss.jbossts.xts.environment.WSTEnvironmentBean;
import org.jboss.jbossts.xts.environment.XTSPropertyManager;

public class ParticipantInitialisation {
    public static void startup() {
        ServiceRegistry serviceRegistry = ServiceRegistry.getRegistry();
        WSCEnvironmentBean wscEnvironmentBean = XTSPropertyManager.getWSCEnvironmentBean();
        String bindAddress = wscEnvironmentBean.getBindAddress11();
        int bindPort = wscEnvironmentBean.getBindPort11();
        int secureBindPort = wscEnvironmentBean.getBindPortSecure11();
        WSTEnvironmentBean wstEnvironmentBean = XTSPropertyManager.getWSTEnvironmentBean();
        String participantServiceURLPath = wstEnvironmentBean.getParticipantServiceURLPath();
        if (participantServiceURLPath == null) {
            participantServiceURLPath = "/ws-t11-participant";
        }
        if (bindAddress == null) {
            bindAddress = "localhost";
        }
        if (bindPort == 0) {
            bindPort = 8080;
        }
        if (secureBindPort == 0) {
            secureBindPort = 8443;
        }
        String baseUri = "http://" + bindAddress + ":" + bindPort + participantServiceURLPath;
        String uri = baseUri + "/" + "ParticipantService";
        String secureBaseUri = "https://" + bindAddress + ":" + secureBindPort + participantServiceURLPath;
        String secureUri = secureBaseUri + "/" + "ParticipantService";
        serviceRegistry.registerServiceProvider("ParticipantService", uri);
        serviceRegistry.registerSecureServiceProvider("ParticipantService", secureUri);
    }

    public static void shutdown() {
    }
}

