/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertiesLoaderUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.URIParserUtil;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.tools.common.AbstractCXFToolContainer;
import org.apache.cxf.tools.common.ClassNameProcessor;
import org.apache.cxf.tools.common.ClassUtils;
import org.apache.cxf.tools.common.FrontEndGenerator;
import org.apache.cxf.tools.common.Processor;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.CommandDocument;
import org.apache.cxf.tools.common.toolspec.parser.CommandLineError;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.FileWriterUtil;
import org.apache.cxf.tools.util.OutputStreamCreator;
import org.apache.cxf.tools.validator.ServiceValidator;
import org.apache.cxf.tools.wsdlto.core.AbstractWSDLBuilder;
import org.apache.cxf.tools.wsdlto.core.DataBindingProfile;
import org.apache.cxf.tools.wsdlto.core.FrontEndProfile;
import org.apache.cxf.wsdl.WSDLConstants;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;
import org.apache.ws.commons.schema.XmlSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDLToJavaContainer
extends AbstractCXFToolContainer {
    protected static final Logger LOG = LogUtils.getL7dLogger(WSDLToJavaContainer.class);
    private static final String DEFAULT_NS2PACKAGE = "http://www.w3.org/2005/08/addressing";
    private static final String SERVICE_VALIDATOR = "META-INF/tools.service.validator.xml";
    String toolName;

    public WSDLToJavaContainer(String name, ToolSpec toolspec) throws Exception {
        super(name, toolspec);
        this.toolName = name;
    }

    public Set<String> getArrayKeys() {
        HashSet<String> set = new HashSet<String>();
        set.add("packagename");
        set.add("nexclude");
        set.add("xjc");
        return set;
    }

    public WSDLConstants.WSDLVersion getWSDLVersion() {
        String version = (String)this.context.get("wsdlversion");
        return WSDLConstants.getVersion((String)version);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws ToolException {
        if (this.hasInfoOption()) {
            return;
        }
        this.buildToolContext();
        boolean isWsdlList = this.context.optionSet("wsdlList");
        if (isWsdlList) {
            BufferedReader reader = null;
            try {
                ToolContext initialContextState = this.context.makeCopy();
                String wsdlURL = (String)this.context.get("wsdlurl");
                wsdlURL = URIParserUtil.getAbsoluteURI((String)wsdlURL);
                URL url = new URL(wsdlURL);
                InputStream is = (InputStream)url.getContent();
                reader = new BufferedReader(new InputStreamReader(is));
                String tempLine = null;
                while ((tempLine = reader.readLine()) != null) {
                    ToolContext freshContext = initialContextState.makeCopy();
                    freshContext.put("wsdlurl", (Object)tempLine);
                    this.setContext(freshContext);
                    this.buildToolContext();
                    this.processWsdl();
                }
                if (this.context.getErrorListener().getErrorCount() <= 0) return;
                this.context.getErrorListener().throwToolException();
                return;
            }
            catch (IOException e) {
                throw new ToolException((Throwable)e);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new ToolException((Throwable)e);
                }
            }
        }
        this.processWsdl();
        if (this.context.getErrorListener().getErrorCount() <= 0) return;
        this.context.getErrorListener().throwToolException();
    }

    private void processWsdl() {
        this.validate(this.context);
        FrontEndProfile frontend = (FrontEndProfile)this.context.get(FrontEndProfile.class);
        if (frontend == null) {
            throw new ToolException(new Message("FOUND_NO_FRONTEND", LOG, new Object[0]));
        }
        WSDLConstants.WSDLVersion version = this.getWSDLVersion();
        String wsdlURL = (String)this.context.get("wsdlurl");
        List serviceList = (ArrayList)this.context.get("serviceList");
        if (serviceList == null) {
            serviceList = new ArrayList();
            if (version == WSDLConstants.WSDLVersion.WSDL11) {
                String serviceName;
                AbstractWSDLBuilder builder = frontend.getWSDLBuilder();
                builder.setContext(this.context);
                builder.setBus(this.getBus());
                this.context.put(Bus.class, (Object)this.getBus());
                wsdlURL = URIParserUtil.getAbsoluteURI((String)wsdlURL);
                builder.build(wsdlURL);
                builder.customize();
                Definition definition = builder.getWSDLModel();
                this.context.put(Definition.class, (Object)definition);
                builder.validate(definition);
                WSDLServiceBuilder serviceBuilder = new WSDLServiceBuilder(this.getBus());
                if (this.context.isVerbose()) {
                    serviceBuilder.setUnwrapLogLevel(Level.INFO);
                }
                serviceBuilder.setIgnoreUnknownBindings(true);
                String allowRefs = (String)this.context.get("allowElementReferences");
                if (!StringUtils.isEmpty((String)allowRefs) || this.context.optionSet("allowElementReferences")) {
                    if (allowRefs.length() > 0 && allowRefs.charAt(0) == '=') {
                        allowRefs = allowRefs.substring(1);
                    }
                    if (StringUtils.isEmpty((String)allowRefs)) {
                        allowRefs = "true";
                    }
                    serviceBuilder.setAllowElementRefs(Boolean.valueOf(allowRefs).booleanValue());
                }
                if ((serviceName = (String)this.context.get("servicename")) != null) {
                    List services = serviceBuilder.buildServices(definition, this.getServiceQName(definition));
                    serviceList.addAll(services);
                } else {
                    serviceList = definition.getServices().size() > 0 ? serviceBuilder.buildServices(definition) : serviceBuilder.buildMockServices(definition);
                }
                ((WSDLManager)this.getBus().getExtension(WSDLManager.class)).removeDefinition(definition);
            }
        }
        this.context.put("serviceList", serviceList);
        LinkedHashMap interfaces = new LinkedHashMap();
        ServiceInfo service0 = (ServiceInfo)serviceList.get(0);
        SchemaCollection schemaCollection = service0.getXmlSchemaCollection();
        this.context.put("xmlSchemaCollection", (Object)schemaCollection);
        this.context.put("portTypeMap", interfaces);
        this.context.put(ClassCollector.class, (Object)this.createClassCollector());
        Processor processor = frontend.getProcessor();
        if (processor instanceof ClassNameProcessor) {
            processor.setEnvironment(this.context);
            for (ServiceInfo service : serviceList) {
                this.context.put(ServiceInfo.class, (Object)service);
                ((ClassNameProcessor)processor).processClassNames();
                this.context.put(ServiceInfo.class, null);
            }
        }
        if (this.context.optionSet("notypes")) {
            this.context.remove("types");
            this.context.remove("all");
            this.context.remove("compile");
        }
        this.generateTypes();
        if (this.context.getErrorListener().getErrorCount() > 0) {
            return;
        }
        for (ServiceInfo service : serviceList) {
            this.context.put(ServiceInfo.class, (Object)service);
            if (this.context.basicValidateWSDL()) {
                this.validate(service);
            }
            if (this.context.getErrorListener().getErrorCount() != 0) continue;
            processor.setEnvironment(this.context);
            processor.process();
        }
        if (this.context.getErrorListener().getErrorCount() > 0) {
            return;
        }
        if (this.context.optionSet("clientjar")) {
            this.enforceWSDLLocation(this.context);
        }
        if (!this.isSuppressCodeGen()) {
            for (FrontEndGenerator generator : frontend.getGenerators()) {
                generator.generate(this.context);
            }
        }
        this.context.remove("serviceList");
        if (this.context.optionSet("compile")) {
            new ClassUtils().compile(this.context);
        }
        if (this.context.isExcludeNamespaceEnabled()) {
            try {
                this.removeExcludeFiles();
            }
            catch (IOException e) {
                throw new ToolException((Throwable)e);
            }
        }
        if (this.context.optionSet("clientjar")) {
            this.processClientJar(this.context);
        }
    }

    private void enforceWSDLLocation(ToolContext context) {
        String wsdlURL = (String)context.get("wsdlurl");
        List serviceList = (List)context.get("serviceList");
        int slashIndex = wsdlURL.lastIndexOf("/");
        int dotIndex = wsdlURL.indexOf(".", slashIndex);
        String wsdlLocation = null;
        if (slashIndex > -1 && dotIndex > -1) {
            wsdlLocation = wsdlURL.substring(slashIndex + 1, dotIndex) + ".wsdl";
        }
        if (wsdlLocation == null) {
            wsdlLocation = ((ServiceInfo)serviceList.get(0)).getName().getLocalPart() + ".wsdl";
        }
        context.put("wsdlLocation", wsdlLocation);
    }

    private void processClientJar(ToolContext context) {
        ClassCollector oldCollector = (ClassCollector)context.get(ClassCollector.class);
        ClassCollector newCollector = new ClassCollector();
        String oldClassDir = (String)context.get("classdir");
        File tmpDir = FileUtils.createTmpDir();
        context.put("classdir", (Object)tmpDir.getAbsolutePath());
        newCollector.setTypesClassNames(oldCollector.getTypesClassNames());
        newCollector.setSeiClassNames(oldCollector.getSeiClassNames());
        newCollector.setExceptionClassNames(oldCollector.getExceptionClassNames());
        newCollector.setServiceClassNames(oldCollector.getServiceClassNames());
        context.put(ClassCollector.class, (Object)newCollector);
        new ClassUtils().compile(context);
        this.generateLocalWSDL(context);
        File clientJarFile = new File((String)context.get("outputdir"), (String)context.get("clientjar"));
        JarOutputStream jarout = null;
        try {
            jarout = new JarOutputStream((OutputStream)new FileOutputStream(clientJarFile), new Manifest());
            this.createClientJar(tmpDir, jarout);
            jarout.close();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "FAILED_TO_CREAT_CLIENTJAR", e);
            Message msg = new Message("FAILED_TO_CREAT_CLIENTJAR", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)e);
        }
        context.put("classdir", (Object)oldClassDir);
        context.put(ClassCollector.class, (Object)oldCollector);
    }

    private void createClientJar(File tmpDirectory, JarOutputStream jarout) {
        try {
            URI parentFile = new File((String)this.context.get("classdir")).toURI();
            for (File file : tmpDirectory.listFiles()) {
                JarEntry entry;
                URI relativePath = parentFile.relativize(file.toURI());
                String name = relativePath.toString();
                if (file.isDirectory()) {
                    if (!StringUtils.isEmpty((String)name)) {
                        if (!name.endsWith("/")) {
                            name = name + "/";
                        }
                        entry = new JarEntry(name);
                        entry.setTime(file.lastModified());
                        jarout.putNextEntry(entry);
                        jarout.closeEntry();
                    }
                    this.createClientJar(file, jarout);
                    continue;
                }
                entry = new JarEntry(name);
                entry.setTime(file.lastModified());
                jarout.putNextEntry(entry);
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
                IOUtils.copy((InputStream)input, (OutputStream)jarout);
                ((InputStream)input).close();
                jarout.closeEntry();
            }
        }
        catch (Exception e) {
            Message msg = new Message("FAILED_ADD_JARENTRY", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)e);
        }
    }

    private boolean isSuppressCodeGen() {
        return this.context.optionSet("suppress");
    }

    public void execute(boolean exitOnFinish) throws ToolException {
        try {
            if (this.getArgument() != null) {
                super.execute(exitOnFinish);
            }
            this.execute();
        }
        catch (ToolException ex) {
            if (ex.getCause() instanceof BadUsageException) {
                this.printUsageException(this.toolName, (BadUsageException)ex.getCause());
            }
            throw ex;
        }
        catch (Exception ex) {
            throw new ToolException((Throwable)ex);
        }
        finally {
            this.tearDown();
        }
    }

    public QName getServiceQName(Definition def) {
        ArrayList<Definition> defs = new ArrayList<Definition>();
        defs.add(def);
        Iterator ite1 = def.getImports().values().iterator();
        while (ite1.hasNext()) {
            List defList = CastUtils.cast((List)((List)ite1.next()));
            for (Import importDef : defList) {
                defs.add(importDef.getDefinition());
            }
        }
        String serviceName = (String)this.context.get("servicename");
        for (Definition definition : defs) {
            if (serviceName == null) continue;
            for (QName qn : definition.getServices().keySet()) {
                if (!qn.getLocalPart().equalsIgnoreCase(serviceName.toLowerCase())) continue;
                return qn;
            }
        }
        Message msg = new Message("SERVICE_NOT_FOUND", LOG, new Object[]{serviceName});
        throw new ToolException(msg);
    }

    public void loadDefaultNSPackageMapping(ToolContext env) {
        if (!env.hasExcludeNamespace(DEFAULT_NS2PACKAGE) && env.getBooleanValue("defaultns", "true") && env.get("noAddressBinding") != null) {
            env.loadDefaultNS2Pck(WSDLToJavaContainer.getResourceAsStream("namespace2package.cfg"));
        }
        if (env.getBooleanValue("defaultex", "true")) {
            env.loadDefaultExcludes(WSDLToJavaContainer.getResourceAsStream("wsdltojavaexclude.cfg"));
        }
    }

    public void setExcludePackageAndNamespaces(ToolContext env) {
        if (env.get("nexclude") != null) {
            String[] pns = null;
            try {
                pns = (String[])env.get("nexclude");
            }
            catch (ClassCastException e) {
                pns = new String[]{(String)env.get("nexclude")};
            }
            for (int j = 0; j < pns.length; ++j) {
                int pos = pns[j].indexOf("=");
                if (pos != -1) {
                    String ns = pns[j].substring(0, pos);
                    if (ns.equals(DEFAULT_NS2PACKAGE)) {
                        env.put("noAddressBinding", (Object)"noAddressBinding");
                    }
                    String excludePackagename = pns[j].substring(pos + 1);
                    env.addExcludeNamespacePackageMap(ns, excludePackagename);
                    env.addNamespacePackageMap(ns, excludePackagename);
                    continue;
                }
                env.addExcludeNamespacePackageMap(pns[j], env.mapPackageName(pns[j]));
            }
        }
    }

    public void setPackageAndNamespaces(ToolContext env) {
        if (env.get("packagename") != null) {
            String[] pns = null;
            try {
                pns = (String[])env.get("packagename");
            }
            catch (ClassCastException e) {
                pns = new String[]{(String)env.get("packagename")};
            }
            for (int j = 0; j < pns.length; ++j) {
                int pos = pns[j].indexOf("=");
                String packagename = pns[j];
                if (pos != -1) {
                    String ns = pns[j].substring(0, pos);
                    if (ns.equals(DEFAULT_NS2PACKAGE)) {
                        env.put("noAddressBinding", (Object)"noAddressBinding");
                    }
                    packagename = pns[j].substring(pos + 1);
                    env.addNamespacePackageMap(ns, packagename);
                    continue;
                }
                env.setPackageName(packagename);
            }
        }
    }

    public void validate(ToolContext env) throws ToolException {
        String[] bindingFiles;
        String wsdl;
        String outdir = (String)env.get("outputdir");
        if (!this.isSuppressCodeGen()) {
            File dir;
            String clsdir;
            if (outdir != null) {
                File dir2 = new File(outdir);
                if (!dir2.exists() && !dir2.mkdirs()) {
                    Message msg = new Message("DIRECTORY_COULD_NOT_BE_CREATED", LOG, new Object[]{outdir});
                    throw new ToolException(msg);
                }
                if (!dir2.isDirectory()) {
                    Message msg = new Message("NOT_A_DIRECTORY", LOG, new Object[]{outdir});
                    throw new ToolException(msg);
                }
            }
            if (env.optionSet("compile") && (clsdir = (String)env.get("classdir")) != null && !(dir = new File(clsdir)).exists() && !dir.mkdirs()) {
                Message msg = new Message("DIRECTORY_COULD_NOT_BE_CREATED", LOG, new Object[]{clsdir});
                throw new ToolException(msg);
            }
        }
        if (StringUtils.isEmpty((String)(wsdl = (String)env.get("wsdlurl")))) {
            Message msg = new Message("NO_WSDL_URL", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        env.put("wsdlurl", (Object)URIParserUtil.getAbsoluteURI((String)wsdl));
        if (!env.containsKey("wsdlLocation")) {
            URI uri;
            boolean assumeFileURI = false;
            try {
                uri = new URI(wsdl);
                String uriScheme = uri.getScheme();
                if (uriScheme == null) {
                    assumeFileURI = true;
                }
                wsdl = uri.toString();
            }
            catch (Exception e) {
                assumeFileURI = true;
            }
            if (assumeFileURI) {
                wsdl = wsdl.indexOf(":") != -1 && !wsdl.startsWith("/") ? "file:/" + wsdl : "file:" + wsdl;
                try {
                    uri = new URI(wsdl);
                    wsdl = uri.toString();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            wsdl = wsdl.replace("\\", "/");
            env.put("wsdlLocation", (Object)wsdl);
        }
        try {
            bindingFiles = (String[])env.get("binding");
            if (bindingFiles == null) {
                return;
            }
        }
        catch (ClassCastException e) {
            bindingFiles = new String[]{(String)env.get("binding")};
        }
        for (int i = 0; i < bindingFiles.length; ++i) {
            bindingFiles[i] = URIParserUtil.getAbsoluteURI((String)bindingFiles[i]);
        }
        env.put("binding", (Object)bindingFiles);
    }

    public void setAntProperties(ToolContext env) {
        String installDir = System.getProperty("install.dir");
        if (installDir != null) {
            env.put("install.dir", (Object)installDir);
        } else {
            env.put("install.dir", (Object)".");
        }
    }

    protected void setLibraryReferences(ToolContext env) {
        Properties props = this.loadProperties(WSDLToJavaContainer.getResourceAsStream("wsdltojavalib.properties"));
        if (props != null) {
            for (String string : props.keySet()) {
                env.put(string, props.get(string));
            }
        }
        env.put("ant.prop", (Object)props);
    }

    public void buildToolContext() {
        this.context = this.getContext();
        this.context.addParameters(this.getParametersMap(this.getArrayKeys()));
        if (this.context.get("outputdir") == null) {
            this.context.put("outputdir", (Object)".");
        }
        if (this.context.containsKey("ant")) {
            this.setAntProperties(this.context);
            this.setLibraryReferences(this.context);
        }
        if (!this.context.containsKey("wsdlversion")) {
            this.context.put("wsdlversion", (Object)"1.1");
        }
        this.context.put("suppressWarnings", (Object)true);
        this.loadDefaultNSPackageMapping(this.context);
        this.setPackageAndNamespaces(this.context);
        this.setExcludePackageAndNamespaces(this.context);
    }

    protected static InputStream getResourceAsStream(String file) {
        return WSDLToJavaContainer.class.getResourceAsStream(file);
    }

    public void checkParams(ErrorVisitor errors) throws ToolException {
        CommandDocument doc = super.getCommandDocument();
        if (!doc.hasParameter("wsdlurl")) {
            errors.add((CommandLineError)new ErrorVisitor.UserError("WSDL/SCHEMA URL has to be specified"));
        }
        if (errors.getErrors().size() > 0) {
            Message msg = new Message("PARAMETER_MISSING", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)new BadUsageException(this.getUsage(), errors));
        }
    }

    public void removeExcludeFiles() throws IOException {
        List excludeGenFiles = this.context.getExcludeFileList();
        if (excludeGenFiles == null) {
            return;
        }
        String outPutDir = (String)this.context.get("outputdir");
        for (int i = 0; i < excludeGenFiles.size(); ++i) {
            String excludeFile = (String)excludeGenFiles.get(i);
            File file = new File(outPutDir, excludeFile);
            file.delete();
            for (File tmpFile = file.getParentFile(); tmpFile != null && !tmpFile.getCanonicalPath().equalsIgnoreCase(outPutDir); tmpFile = tmpFile.getParentFile()) {
                if (!tmpFile.isDirectory() || tmpFile.list().length != 0) continue;
                tmpFile.delete();
            }
            if (this.context.get("compile") == null) continue;
            String classDir = this.context.get("classdir") == null ? outPutDir : (String)this.context.get("classdir");
            File classFile = new File(classDir, excludeFile.substring(0, excludeFile.indexOf(".java")) + ".class");
            classFile.delete();
            for (File tmpClzFile = classFile.getParentFile(); tmpClzFile != null && !tmpClzFile.getCanonicalPath().equalsIgnoreCase(outPutDir); tmpClzFile = tmpClzFile.getParentFile()) {
                if (!tmpClzFile.isDirectory() || tmpClzFile.list().length != 0) continue;
                tmpClzFile.delete();
            }
        }
    }

    public boolean passthrough() {
        if (this.context.optionSet("genTypes") || this.context.optionSet("all")) {
            return false;
        }
        if (this.context.optionSet("genAnt") || this.context.optionSet("genClient") || this.context.optionSet("genImpl") || this.context.optionSet("genSEI") || this.context.optionSet("genServer") || this.context.optionSet("genService") || this.context.optionSet("genFault")) {
            return true;
        }
        return this.context.optionSet("notypes");
    }

    public void generateTypes() throws ToolException {
        DataBindingProfile dataBindingProfile = (DataBindingProfile)this.context.get(DataBindingProfile.class);
        if (dataBindingProfile == null) {
            Message msg = new Message("FOUND_NO_DATABINDING", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        dataBindingProfile.initialize(this.context);
        if (this.passthrough()) {
            return;
        }
        dataBindingProfile.generate(this.context);
    }

    public void validate(ServiceInfo service) throws ToolException {
        for (ServiceValidator validator : this.getServiceValidators()) {
            service.setProperty(ToolContext.class.getName(), (Object)this.context);
            validator.setService(service);
            if (validator.isValid()) continue;
            throw new ToolException(validator.getErrorMessage());
        }
    }

    public List<ServiceValidator> getServiceValidators() {
        ArrayList<ServiceValidator> validators = new ArrayList<ServiceValidator>();
        Properties initialExtensions = null;
        try {
            initialExtensions = PropertiesLoaderUtils.loadAllProperties((String)SERVICE_VALIDATOR, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        for (String string : initialExtensions.values()) {
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Found service validator : " + string);
                }
                ServiceValidator validator = (ServiceValidator)Class.forName(string, true, Thread.currentThread().getContextClassLoader()).newInstance();
                validators.add(validator);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "EXTENSION_ADD_FAILED_MSG", ex);
            }
        }
        return validators;
    }

    private void generateLocalWSDL(ToolContext context) {
        String outputdir = (String)context.get("classdir");
        File wsdlFile = new File(outputdir, (String)context.get("wsdlLocation"));
        Definition def = (Definition)context.get(Definition.class);
        try {
            int xsdCount = 0;
            SchemaCollection schemas = (SchemaCollection)context.get("xmlSchemaCollection");
            HashMap<String, String> sourceMap = new HashMap<String, String>();
            for (XmlSchema imp : schemas.getXmlSchemas()) {
                if (imp.getSourceURI() == null || imp.getSourceURI().contains(".wsdl#")) continue;
                String schemaFileName = "schema" + ++xsdCount + ".xsd";
                sourceMap.put(imp.getTargetNamespace(), schemaFileName);
            }
            List defs = (List)context.get("importedDefinition");
            HashMap<String, String> importWSDLMap = new HashMap<String, String>();
            for (Definition importDef : defs) {
                File importedWsdlFile = null;
                importedWsdlFile = !StringUtils.isEmpty((String)importDef.getDocumentBaseURI()) ? new File(importDef.getDocumentBaseURI()) : new File(importDef.getQName().getLocalPart() + ".wsdl");
                importWSDLMap.put(importDef.getTargetNamespace(), importedWsdlFile.getName());
            }
            OutputStreamCreator outputStreamCreator = null;
            if (context.get(OutputStreamCreator.class) != null) {
                outputStreamCreator = (OutputStreamCreator)context.get(OutputStreamCreator.class);
            } else {
                outputStreamCreator = new OutputStreamCreator();
                context.put(OutputStreamCreator.class, (Object)outputStreamCreator);
            }
            Writer os = null;
            for (XmlSchema imp : schemas.getXmlSchemas()) {
                if (imp.getSourceURI() == null || imp.getSourceURI().contains(".wsdl#")) continue;
                String schemaFileName = (String)sourceMap.get(imp.getTargetNamespace());
                File impfile = new File(wsdlFile.getParentFile(), schemaFileName);
                Element el = imp.getSchemaDocument().getDocumentElement();
                this.updateImports(el, sourceMap);
                os = new FileWriterUtil(impfile.getParent(), (OutputStreamCreator)context.get(OutputStreamCreator.class)).getWriter(impfile, "UTF-8");
                StaxUtils.writeTo((Node)el, (Writer)os, (int)2);
                os.close();
            }
            BufferedOutputStream wsdloutput = new BufferedOutputStream(new FileOutputStream(wsdlFile));
            WSDLWriter wsdlWriter = WSDLFactory.newInstance().newWSDLWriter();
            LoadingByteArrayOutputStream bout = new LoadingByteArrayOutputStream();
            wsdlWriter.writeWSDL(def, (OutputStream)bout);
            Element defEle = StaxUtils.read((InputStream)bout.createInputStream()).getDocumentElement();
            List xsdElements = DOMUtils.findAllElementsByTagNameNS((Element)defEle, (String)"http://www.w3.org/2001/XMLSchema", (String)"schema");
            for (Element xsdEle : xsdElements) {
                this.updateImports(xsdEle, sourceMap);
            }
            this.updateWSDLImports(defEle, importWSDLMap);
            StaxUtils.writeTo((Node)defEle, (OutputStream)wsdloutput);
            ((OutputStream)wsdloutput).close();
            for (Definition importDef : defs) {
                File importWsdlFile = new File(outputdir, (String)importWSDLMap.get(importDef.getTargetNamespace()));
                BufferedOutputStream wsdlOs = new BufferedOutputStream(new FileOutputStream(importWsdlFile));
                bout = new LoadingByteArrayOutputStream();
                wsdlWriter.writeWSDL(importDef, (OutputStream)bout);
                Element importEle = StaxUtils.read((InputStream)bout.createInputStream()).getDocumentElement();
                xsdElements = DOMUtils.findAllElementsByTagNameNS((Element)importEle, (String)"http://www.w3.org/2001/XMLSchema", (String)"schema");
                for (Element xsdEle : xsdElements) {
                    this.updateImports(xsdEle, sourceMap);
                }
                this.updateWSDLImports(importEle, importWSDLMap);
                StaxUtils.writeTo((Node)importEle, (OutputStream)wsdlOs);
                ((OutputStream)wsdlOs).close();
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "FAILED_TO_GEN_LOCAL_WSDL", ex);
            Message msg = new Message("FAILED_TO_GEN_LOCAL_WSDL", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)ex);
        }
    }

    private void updateImports(Element el, Map<String, String> sourceMap) {
        List imps = DOMUtils.getChildrenWithName((Element)el, (String)"http://www.w3.org/2001/XMLSchema", (String)"import");
        for (Element e : imps) {
            String ns = e.getAttribute("namespace");
            e.setAttribute("schemaLocation", sourceMap.get(ns));
        }
    }

    private void updateWSDLImports(Element el, Map<String, String> wsdlSourceMap) {
        List imps = DOMUtils.getChildrenWithName((Element)el, (String)WSDLConstants.QNAME_IMPORT.getNamespaceURI(), (String)"import");
        for (Element e : imps) {
            String ns = e.getAttribute("namespace");
            e.setAttribute("location", wsdlSourceMap.get(ns));
        }
    }
}

