/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.network.SocketBinding;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.service.ProtocolStackServiceName;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public abstract class AbstractProtocolConfigurationBuilder<P extends ProtocolConfiguration>
implements Builder<P>,
Value<P>,
ProtocolConfiguration {
    final String stackName;
    final String name;
    private final Map<String, String> properties = new HashMap<String, String>();
    private ModuleIdentifier module = ProtocolConfiguration.DEFAULT_MODULE;
    private ValueDependency<SocketBinding> socketBinding;

    public AbstractProtocolConfigurationBuilder(String stackName, String name) {
        this.stackName = stackName;
        this.name = name;
    }

    public ServiceName getServiceName() {
        return ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(this.stackName).append(new String[]{this.name});
    }

    public ServiceBuilder<P> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this));
        if (this.socketBinding != null) {
            this.socketBinding.register(builder);
        }
        return builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public AbstractProtocolConfigurationBuilder<P> setModule(ModuleIdentifier module) {
        this.module = module;
        return this;
    }

    public AbstractProtocolConfigurationBuilder<P> setSocketBinding(String socketBindingName) {
        if (socketBindingName != null) {
            this.socketBinding = new InjectedValueDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBindingName}), SocketBinding.class);
        }
        return this;
    }

    public AbstractProtocolConfigurationBuilder<P> addProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getProtocolClassName() {
        StringBuilder builder = new StringBuilder();
        if (this.module.equals(ProtocolConfiguration.DEFAULT_MODULE) && !this.name.startsWith("org.jgroups.protocols")) {
            builder.append("org.jgroups.protocols").append('.');
        }
        return builder.append(this.name).toString();
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    public SocketBinding getSocketBinding() {
        return this.socketBinding != null ? (SocketBinding)this.socketBinding.getValue() : null;
    }

    public ModuleIdentifier getModule() {
        return this.module;
    }
}

