/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller.transform;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.dmr.ModelNode;

public class SimpleRejectAttributeChecker
implements RejectAttributeChecker {
    private final String logMessageId = UUID.randomUUID().toString();
    private final Rejecter rejecter;

    public SimpleRejectAttributeChecker(Rejecter rejecter) {
        this.rejecter = rejecter;
    }

    public boolean rejectOperationParameter(PathAddress address, String name, ModelNode value, ModelNode operation, TransformationContext context) {
        return this.rejecter.reject(address, name, value, operation, context);
    }

    public boolean rejectResourceAttribute(PathAddress address, String name, ModelNode value, TransformationContext context) {
        return this.rejecter.reject(address, name, value, context.readResourceFromRoot(address).getModel(), context);
    }

    public String getRejectionLogMessageId() {
        return this.logMessageId;
    }

    public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
        return this.rejecter.getRejectedMessage(attributes.keySet());
    }

    public static interface Rejecter {
        public boolean reject(PathAddress var1, String var2, ModelNode var3, ModelNode var4, TransformationContext var5);

        public String getRejectedMessage(Set<String> var1);
    }
}

