/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.protocol.AbstractMessageHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.ChannelAssociation;
import org.jboss.as.ejb3.remote.protocol.versionone.UserTransactionCommitTask;
import org.jboss.as.ejb3.remote.protocol.versionone.UserTransactionManagementTask;
import org.jboss.as.ejb3.remote.protocol.versionone.UserTransactionRollbackTask;
import org.jboss.as.ejb3.remote.protocol.versionone.XidTransactionBeforeCompletionTask;
import org.jboss.as.ejb3.remote.protocol.versionone.XidTransactionCommitTask;
import org.jboss.as.ejb3.remote.protocol.versionone.XidTransactionForgetTask;
import org.jboss.as.ejb3.remote.protocol.versionone.XidTransactionManagementTask;
import org.jboss.as.ejb3.remote.protocol.versionone.XidTransactionPrepareTask;
import org.jboss.as.ejb3.remote.protocol.versionone.XidTransactionRollbackTask;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.client.UserTransactionID;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.remoting3.MessageOutputStream;

class TransactionRequestHandler
extends AbstractMessageHandler {
    private static final byte HEADER_TX_INVOCATION_RESPONSE = 20;
    private final ExecutorService executorService;
    private final EJBRemoteTransactionsRepository transactionsRepository;
    private final TransactionRequestType txRequestType;
    private final MarshallerFactory marshallerFactory;

    TransactionRequestHandler(EJBRemoteTransactionsRepository transactionsRepository, MarshallerFactory marshallerFactory, ExecutorService executorService, TransactionRequestType txRequestType) {
        this.executorService = executorService;
        this.transactionsRepository = transactionsRepository;
        this.txRequestType = txRequestType;
        this.marshallerFactory = marshallerFactory;
    }

    @Override
    public void processMessage(ChannelAssociation channelAssociation, InputStream inputStream) throws IOException {
        DataInputStream input = new DataInputStream(inputStream);
        short invocationId = input.readShort();
        int transactionIDBytesLength = PackedInteger.readPackedInteger((DataInput)input);
        byte[] transactionIDBytes = new byte[transactionIDBytesLength];
        input.read(transactionIDBytes);
        TransactionID transactionID = TransactionID.createTransactionID((byte[])transactionIDBytes);
        boolean onePhaseCommit = false;
        if (this.txRequestType == TransactionRequestType.COMMIT) {
            onePhaseCommit = input.readBoolean();
        }
        if (transactionID instanceof UserTransactionID) {
            UserTransactionManagementTask userTransactionManagementTask;
            switch (this.txRequestType) {
                case COMMIT: {
                    userTransactionManagementTask = new UserTransactionCommitTask(this, this.transactionsRepository, this.marshallerFactory, (UserTransactionID)transactionID, channelAssociation, invocationId);
                    break;
                }
                case ROLLBACK: {
                    userTransactionManagementTask = new UserTransactionRollbackTask(this, this.transactionsRepository, this.marshallerFactory, (UserTransactionID)transactionID, channelAssociation, invocationId);
                    break;
                }
                default: {
                    throw EjbLogger.ROOT_LOGGER.unknownTransactionRequestType(this.txRequestType.name());
                }
            }
            this.executorService.submit(userTransactionManagementTask);
        } else if (transactionID instanceof XidTransactionID) {
            XidTransactionManagementTask xidTransactionManagementTask;
            XidTransactionID xidTransactionID = (XidTransactionID)transactionID;
            switch (this.txRequestType) {
                case COMMIT: {
                    xidTransactionManagementTask = new XidTransactionCommitTask(this, this.transactionsRepository, this.marshallerFactory, xidTransactionID, channelAssociation, invocationId, onePhaseCommit);
                    break;
                }
                case PREPARE: {
                    xidTransactionManagementTask = new XidTransactionPrepareTask(this, this.transactionsRepository, this.marshallerFactory, xidTransactionID, channelAssociation, invocationId);
                    break;
                }
                case ROLLBACK: {
                    xidTransactionManagementTask = new XidTransactionRollbackTask(this, this.transactionsRepository, this.marshallerFactory, xidTransactionID, channelAssociation, invocationId);
                    break;
                }
                case FORGET: {
                    xidTransactionManagementTask = new XidTransactionForgetTask(this, this.transactionsRepository, this.marshallerFactory, xidTransactionID, channelAssociation, invocationId);
                    break;
                }
                case BEFORE_COMPLETION: {
                    xidTransactionManagementTask = new XidTransactionBeforeCompletionTask(this, this.transactionsRepository, this.marshallerFactory, xidTransactionID, channelAssociation, invocationId);
                    break;
                }
                default: {
                    throw EjbLogger.ROOT_LOGGER.unknownTransactionRequestType(this.txRequestType.name());
                }
            }
            this.executorService.submit(xidTransactionManagementTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTxPrepareResponseMessage(ChannelAssociation channelAssociation, short invocationId, int xaResourceStatusCode) throws IOException {
        MessageOutputStream messageOutputStream;
        try {
            messageOutputStream = channelAssociation.acquireChannelMessageOutputStream();
        }
        catch (Exception e) {
            throw EjbLogger.ROOT_LOGGER.failedToOpenMessageOutputStream(e);
        }
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)messageOutputStream);
        try {
            dataOutputStream.writeByte(20);
            dataOutputStream.writeShort(invocationId);
            dataOutputStream.writeBoolean(true);
            PackedInteger.writePackedInteger((DataOutput)dataOutputStream, (int)xaResourceStatusCode);
        }
        finally {
            channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
            dataOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTxInvocationResponseMessage(ChannelAssociation channelAssociation, short invocationId) throws IOException {
        MessageOutputStream messageOutputStream;
        try {
            messageOutputStream = channelAssociation.acquireChannelMessageOutputStream();
        }
        catch (Exception e) {
            throw EjbLogger.ROOT_LOGGER.failedToOpenMessageOutputStream(e);
        }
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)messageOutputStream);
        try {
            dataOutputStream.writeByte(20);
            dataOutputStream.writeShort(invocationId);
            dataOutputStream.writeBoolean(false);
        }
        finally {
            channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
            dataOutputStream.close();
        }
    }

    @Override
    protected void writeException(ChannelAssociation channelAssociation, MarshallerFactory marshallerFactory, short invocationId, Throwable t, Map<String, Object> attachments) throws IOException {
        super.writeException(channelAssociation, marshallerFactory, invocationId, t, attachments);
    }

    static enum TransactionRequestType {
        COMMIT,
        ROLLBACK,
        PREPARE,
        FORGET,
        BEFORE_COMPLETION;

    }
}

