/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.dynamicresource;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.connector.dynamicresource.ClearStatisticsHandler;
import org.jboss.as.connector.subsystems.common.pool.Constants;
import org.jboss.as.connector.subsystems.common.pool.PoolMetrics;
import org.jboss.as.connector.subsystems.common.pool.PoolStatisticsRuntimeAttributeReadHandler;
import org.jboss.as.connector.subsystems.common.pool.PoolStatisticsRuntimeAttributeWriteHandler;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersExtension;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelType;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;

public class StatisticsResourceDefinition
extends SimpleResourceDefinition {
    private final StatisticsPlugin plugin;

    public StatisticsResourceDefinition(PathElement path, String bundleName, StatisticsPlugin plugin) {
        super(path, StatisticsResourceDefinition.getResolver("statistics", bundleName, plugin));
        this.plugin = plugin;
    }

    private static ResourceDescriptionResolver getResolver(final String keyPrefix, String bundleName, final StatisticsPlugin plugin) {
        return new StandardResourceDescriptionResolver(keyPrefix, bundleName, ResourceAdaptersExtension.class.getClassLoader(), true, false){

            public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle) {
                if (bundle.containsKey(keyPrefix + "." + attributeName)) {
                    return super.getResourceAttributeDescription(attributeName, locale, bundle);
                }
                return plugin.getDescription(attributeName);
            }
        };
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        for (AttributeDefinition attribute : StatisticsResourceDefinition.getAttributesFromPlugin(this.plugin)) {
            resourceRegistration.registerMetric(attribute, (OperationStepHandler)new PoolMetrics.ParametrizedPoolMetricsHandler(this.plugin));
        }
        PoolStatisticsRuntimeAttributeReadHandler readHandler = new PoolStatisticsRuntimeAttributeReadHandler(this.plugin);
        PoolStatisticsRuntimeAttributeWriteHandler writeHandler = new PoolStatisticsRuntimeAttributeWriteHandler(this.plugin);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)Constants.POOL_STATISTICS_ENABLED, (OperationStepHandler)readHandler, (OperationStepHandler)writeHandler);
    }

    public static List<AttributeDefinition> getAttributesFromPlugin(StatisticsPlugin plugin) {
        LinkedList<AttributeDefinition> result = new LinkedList<AttributeDefinition>();
        for (String name : plugin.getNames()) {
            ModelType modelType = ModelType.STRING;
            if (plugin.getType(name) == Integer.TYPE) {
                modelType = ModelType.INT;
            }
            if (plugin.getType(name) == Long.TYPE) {
                modelType = ModelType.LONG;
            }
            SimpleAttributeDefinition attribute = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, modelType).setAllowNull(true)).setStorageRuntime()).build();
            result.add((AttributeDefinition)attribute);
        }
        return result;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(ClearStatisticsHandler.DEFINITION, (OperationStepHandler)new ClearStatisticsHandler(this.plugin));
    }
}

